/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.exception.UDFException;

public abstract class ValueRepair {
    protected int n;
    protected long[] time;
    protected double[] original;
    protected double[] repaired;

    protected ValueRepair(RowIterator dataIterator) throws Exception {
        ArrayList<Long> timeList = new ArrayList<Long>();
        ArrayList<Double> originList = new ArrayList<Double>();
        while (dataIterator.hasNextRow()) {
            Row row = dataIterator.next();
            Double v = Util.getValueAsDouble(row);
            timeList.add(row.getTime());
            if (!Double.isFinite(v)) {
                originList.add(Double.NaN);
                continue;
            }
            originList.add(v);
        }
        this.time = Util.toLongArray(timeList);
        this.original = Util.toDoubleArray(originList);
        this.n = this.time.length;
        this.repaired = new double[this.n];
        this.processNaN();
    }

    public abstract void repair();

    private void processNaN() throws UDFException {
        int i;
        int index2;
        int index1;
        for (index1 = 0; index1 < this.n && Double.isNaN(this.original[index1]); ++index1) {
        }
        for (index2 = index1 + 1; index2 < this.n && Double.isNaN(this.original[index2]); ++index2) {
        }
        if (index2 >= this.n) {
            throw new UDFException("At least two non-NaN values are needed");
        }
        for (i = 0; i < index2; ++i) {
            this.original[i] = this.original[index1] + (this.original[index2] - this.original[index1]) * (double)(this.time[i] - this.time[index1]) / (double)(this.time[index2] - this.time[index1]);
        }
        for (i = index2 + 1; i < this.n; ++i) {
            if (Double.isNaN(this.original[i])) continue;
            index1 = index2;
            index2 = i;
            for (int j = index1 + 1; j < index2; ++j) {
                this.original[j] = this.original[index1] + (this.original[index2] - this.original[index1]) * (double)(this.time[j] - this.time[index1]) / (double)(this.time[index2] - this.time[index1]);
            }
        }
        for (i = index2 + 1; i < this.n; ++i) {
            this.original[i] = this.original[index1] + (this.original[index2] - this.original[index1]) * (double)(this.time[i] - this.time[index1]) / (double)(this.time[index2] - this.time[index1]);
        }
    }

    public long[] getTime() {
        return this.time;
    }

    public double[] getRepaired() {
        return this.repaired;
    }
}

