/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractDatabaseMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractMeasurementMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateOrUpdateDevice;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.DeviceAttributeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.IDeviceAttributeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info.TableDeviceInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.snapshot.MemMTreeSnapshotUtil;
import org.apache.iotdb.db.schemaengine.schemaregion.tag.TagLogFile;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRStatementGenerator
implements Iterator<Object>,
Iterable<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SRStatementGenerator.class);
    private IMemMNode curNode;
    private Exception lastExcept = null;
    private final InputStream inputStream;
    private final FileChannel tagFileChannel;
    private final MemSchemaRegionStatistics schemaRegionStatistics = new MemSchemaRegionStatistics(-1, SchemaEngine.getInstance().getSchemaEngineStatistics());
    private final IDeviceAttributeStore deviceAttributeStore = new DeviceAttributeStore(this.schemaRegionStatistics);
    private final Deque<IMemMNode> ancestors = new ArrayDeque<IMemMNode>();
    private final Deque<Integer> restChildrenNum = new ArrayDeque<Integer>();
    private final PartialPath databaseFullPath;
    private final Deque<Object> statements = new ArrayDeque<Object>();
    private final MNodeTranslator translator = new MNodeTranslator();
    private final MemMTreeSnapshotUtil.MNodeDeserializer deserializer = new MemMTreeSnapshotUtil.MNodeDeserializer();
    private int nodeCount = 0;
    private static final int MAX_SCHEMA_BATCH_SIZE = PipeConfig.getInstance().getPipeSnapshotExecutionMaxBatchSize();
    private String tableName;
    private List<Object[]> tableDeviceIdList = new ArrayList<Object[]>();
    private List<String> attributeNameList = null;
    private List<Object[]> attributeValueList = new ArrayList<Object[]>();
    private boolean isClosed = false;

    public SRStatementGenerator(File mtreeFile, File tagFile, File attributeFile, PartialPath databaseFullPath) throws IOException {
        this.inputStream = Files.newInputStream(mtreeFile.toPath(), new OpenOption[0]);
        this.tagFileChannel = tagFile != null ? FileChannel.open(tagFile.toPath(), StandardOpenOption.READ) : null;
        if (Objects.nonNull(attributeFile)) {
            this.deviceAttributeStore.loadFromSnapshot(attributeFile.getParentFile());
        }
        this.databaseFullPath = databaseFullPath;
        Byte version = ReadWriteIOUtils.readByte((InputStream)this.inputStream);
        this.curNode = this.deserializeMNode(this.ancestors, this.restChildrenNum, this.deserializer, this.inputStream, this.schemaRegionStatistics);
        ++this.nodeCount;
    }

    @Override
    @Nonnull
    public Iterator<Object> iterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (!this.statements.isEmpty()) {
            return true;
        }
        if (this.lastExcept != null) {
            return false;
        }
        while (!this.ancestors.isEmpty()) {
            int childNum = this.restChildrenNum.pop();
            if (childNum == 0) {
                Statement stmt;
                IMemMNode node = this.ancestors.pop();
                if (node.isDevice() && node.getAsDeviceMNode().isAligned() && Objects.nonNull(stmt = this.genAlignedTimeseriesStatement(node, this.databaseFullPath.concatPath(node.getPartialPath(), 1)))) {
                    this.statements.push(stmt);
                }
                this.cleanMTreeNode(node);
                if (this.ancestors.isEmpty()) {
                    this.emitDevice();
                }
                if (this.statements.isEmpty()) continue;
                return true;
            }
            this.restChildrenNum.push(childNum - 1);
            try {
                this.curNode = this.deserializeMNode(this.ancestors, this.restChildrenNum, this.deserializer, this.inputStream, this.schemaRegionStatistics);
                ++this.nodeCount;
            }
            catch (IOException ioe) {
                this.lastExcept = ioe;
                try {
                    this.inputStream.close();
                    if (Objects.nonNull(this.tagFileChannel)) {
                        this.tagFileChannel.close();
                    }
                    this.deviceAttributeStore.clear();
                }
                catch (IOException e) {
                    this.lastExcept = e;
                }
                finally {
                    this.schemaRegionStatistics.clear();
                }
                return false;
            }
            List stmts = (List)this.curNode.accept(this.translator, this.databaseFullPath.concatPath(this.curNode.getPartialPath(), 1));
            if (stmts != null) {
                this.statements.addAll(stmts);
            }
            if (this.statements.isEmpty()) continue;
            return true;
        }
        if (!this.isClosed) {
            try {
                this.inputStream.close();
                if (this.tagFileChannel != null) {
                    this.tagFileChannel.close();
                }
                this.deviceAttributeStore.clear();
            }
            catch (IOException e) {
                this.lastExcept = e;
            }
            finally {
                this.schemaRegionStatistics.clear();
            }
            this.isClosed = true;
        }
        return false;
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.statements.pop();
    }

    public void checkException() throws IOException {
        if (this.lastExcept != null) {
            throw new IOException(this.lastExcept);
        }
    }

    private void cleanMTreeNode(IMNode node) {
        IMNodeContainer children = node.getAsInternalMNode().getChildren();
        this.nodeCount -= children.size();
        children.values().forEach(child -> this.schemaRegionStatistics.releaseMemory(child.estimateSize()));
        node.getChildren().clear();
    }

    private IMemMNode deserializeMNode(Deque<IMemMNode> ancestors, Deque<Integer> restChildrenNum, MemMTreeSnapshotUtil.MNodeDeserializer deserializer, InputStream inputStream, MemSchemaRegionStatistics regionStatistics) throws IOException {
        IMemMNode node;
        int childrenNum;
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        switch (type) {
            case 0: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeInternalMNode(inputStream);
                if (ancestors.size() != 1) break;
                this.emitDevice();
                this.tableName = node.getName();
                break;
            }
            case 1: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupMNode(inputStream);
                break;
            }
            case 3: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeEntityMNode(inputStream);
                break;
            }
            case 4: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupEntityMNode(inputStream);
                break;
            }
            case 2: {
                childrenNum = 0;
                node = deserializer.deserializeMeasurementMNode(inputStream);
                break;
            }
            case 5: {
                childrenNum = 0;
                node = deserializer.deserializeLogicalViewMNode(inputStream);
                break;
            }
            case 6: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeTableDeviceMNode(inputStream);
                if (ancestors.size() != 1) break;
                this.emitDevice();
                this.tableName = node.getName();
                break;
            }
            default: {
                throw new IOException("Unrecognized MNode type" + type);
            }
        }
        regionStatistics.requestMemory(node.estimateSize());
        if (!ancestors.isEmpty()) {
            IMemMNode parent = ancestors.peek();
            node.setParent(ancestors.peek());
            parent.addChild(node);
        }
        if (childrenNum > 0 || SchemaConstant.isStorageGroupType((byte)type)) {
            ancestors.push(node);
            restChildrenNum.push(childrenNum);
        }
        return node;
    }

    private void emitDevice() {
        if (Objects.nonNull(this.attributeNameList)) {
            this.statements.add(new CreateOrUpdateDevice(this.databaseFullPath.getNodes()[1], this.tableName, this.tableDeviceIdList, this.attributeNameList, this.attributeValueList));
            this.tableDeviceIdList = new ArrayList<Object[]>();
            this.attributeNameList = null;
            this.attributeValueList = new ArrayList<Object[]>();
        }
    }

    private Statement genAlignedTimeseriesStatement(IMNode node, PartialPath path) {
        IMNodeContainer measurements = node.getAsInternalMNode().getChildren();
        if (node.getAsDeviceMNode().isAligned()) {
            CreateAlignedTimeSeriesStatement stmt = new CreateAlignedTimeSeriesStatement();
            stmt.setDevicePath(path);
            boolean hasMeasurement = false;
            for (IMemMNode measurement : measurements.values()) {
                if (!measurement.isMeasurement() || measurement.getAsMeasurementMNode().isLogicalView()) continue;
                hasMeasurement = true;
                stmt.addMeasurement(measurement.getName());
                stmt.addDataType(measurement.getAsMeasurementMNode().getDataType());
                if (measurement.getAlias() != null) {
                    stmt.addAliasList(measurement.getAlias());
                } else {
                    stmt.addAliasList(null);
                }
                stmt.addEncoding(measurement.getAsMeasurementMNode().getSchema().getEncodingType());
                stmt.addCompressor(measurement.getAsMeasurementMNode().getSchema().getCompressor());
                if (measurement.getAsMeasurementMNode().getOffset() >= 0L) {
                    try {
                        Pair<Map<String, String>, Map<String, String>> tagsAndAttributes = this.getTagsAndAttributes(measurement.getAsMeasurementMNode().getOffset());
                        if (tagsAndAttributes != null) {
                            stmt.addAttributesList((Map)tagsAndAttributes.right);
                            stmt.addTagsList((Map)tagsAndAttributes.left);
                        }
                    }
                    catch (IOException ioException) {
                        this.lastExcept = ioException;
                        LOGGER.warn("Error when parse tag and attributes file of node path {}", (Object)path, (Object)ioException);
                    }
                    measurement.getAsMeasurementMNode().setOffset(0L);
                    continue;
                }
                stmt.addAttributesList(null);
                stmt.addTagsList(null);
            }
            return hasMeasurement ? stmt : null;
        }
        return null;
    }

    private Pair<Map<String, String>, Map<String, String>> getTagsAndAttributes(long offset) throws IOException {
        if (this.tagFileChannel != null) {
            ByteBuffer byteBuffer = TagLogFile.parseByteBuffer(this.tagFileChannel, offset);
            Pair tagsAndAttributes = new Pair((Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer), (Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
            return tagsAndAttributes;
        }
        LOGGER.warn("Measurement has set attributes or tags, but not find snapshot files");
        return null;
    }

    private class MNodeTranslator
    extends MNodeVisitor<List<Object>, PartialPath> {
        private MNodeTranslator() {
        }

        public List<Object> visitBasicMNode(IMNode<?> node, PartialPath path) {
            if (node.isDevice()) {
                return this.genActivateTemplateOrUpdateDeviceStatement(node, path);
            }
            return null;
        }

        public List<Object> visitDatabaseMNode(AbstractDatabaseMNode<?, ? extends IMNode<?>> node, PartialPath path) {
            if (node.isDevice()) {
                return this.genActivateTemplateOrUpdateDeviceStatement((IMNode<?>)node, path);
            }
            return null;
        }

        public List<Object> visitMeasurementMNode(AbstractMeasurementMNode<?, ? extends IMNode<?>> node, PartialPath path) {
            path = new MeasurementPath(path.getNodes());
            if (node.isLogicalView()) {
                ArrayList<Object> statementList = new ArrayList<Object>();
                CreateLogicalViewStatement stmt = new CreateLogicalViewStatement();
                LogicalViewSchema viewSchema = (LogicalViewSchema)node.getAsMeasurementMNode().getSchema();
                if (viewSchema != null) {
                    stmt.setTargetFullPaths(Collections.singletonList(path));
                    stmt.setViewExpressions(Collections.singletonList(viewSchema.getExpression()));
                    statementList.add(stmt);
                }
                if (node.getOffset() >= 0L) {
                    AlterTimeSeriesStatement alterTimeSeriesStatement = new AlterTimeSeriesStatement(true);
                    alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.UPSERT);
                    alterTimeSeriesStatement.setPath((MeasurementPath)path);
                    try {
                        Pair tagsAndAttribute = SRStatementGenerator.this.getTagsAndAttributes(node.getOffset());
                        if (tagsAndAttribute != null) {
                            alterTimeSeriesStatement.setTagsMap((Map)tagsAndAttribute.left);
                            alterTimeSeriesStatement.setAttributesMap((Map)tagsAndAttribute.right);
                            statementList.add(alterTimeSeriesStatement);
                        }
                    }
                    catch (IOException ioException) {
                        SRStatementGenerator.this.lastExcept = ioException;
                        LOGGER.warn("Error when parse tag and attributes file of node path {}", (Object)path, (Object)ioException);
                    }
                }
                return statementList;
            }
            if (node.getParent().getAsDeviceMNode().isAligned()) {
                return null;
            }
            CreateTimeSeriesStatement stmt = new CreateTimeSeriesStatement();
            stmt.setPath((MeasurementPath)path);
            stmt.setAlias(node.getAlias());
            stmt.setCompressor(node.getAsMeasurementMNode().getSchema().getCompressor());
            stmt.setDataType(node.getDataType());
            stmt.setEncoding(node.getAsMeasurementMNode().getSchema().getEncodingType());
            if (node.getOffset() >= 0L) {
                try {
                    Pair tagsAndAttributes = SRStatementGenerator.this.getTagsAndAttributes(node.getOffset());
                    if (tagsAndAttributes != null) {
                        stmt.setTags((Map)tagsAndAttributes.left);
                        stmt.setAttributes((Map)tagsAndAttributes.right);
                    }
                }
                catch (IOException ioException) {
                    SRStatementGenerator.this.lastExcept = ioException;
                    LOGGER.warn("Error when parser tag and attributes files", (Throwable)ioException);
                }
                node.setOffset(0L);
            }
            return Collections.singletonList(stmt);
        }

        private List<Object> genActivateTemplateOrUpdateDeviceStatement(IMNode<?> node, PartialPath path) {
            IDeviceMNode deviceMNode = node.getAsDeviceMNode();
            if (deviceMNode.isUseTemplate()) {
                return Collections.singletonList(new ActivateTemplateStatement(path));
            }
            if (deviceMNode.getDeviceInfo() instanceof TableDeviceInfo && ((TableDeviceInfo)deviceMNode.getDeviceInfo()).getAttributePointer() > -1) {
                Map<String, Binary> tableAttributes = SRStatementGenerator.this.deviceAttributeStore.getAttributes(((TableDeviceInfo)deviceMNode.getDeviceInfo()).getAttributePointer());
                if (tableAttributes.isEmpty()) {
                    return null;
                }
                if (Objects.isNull(SRStatementGenerator.this.attributeNameList)) {
                    SRStatementGenerator.this.attributeNameList = new ArrayList<String>(tableAttributes.keySet());
                }
                List attributeValues = SRStatementGenerator.this.attributeNameList.stream().map(tableAttributes::remove).collect(Collectors.toList());
                tableAttributes.forEach((attributeKey, attributeValue) -> {
                    SRStatementGenerator.this.attributeNameList.add(attributeKey);
                    attributeValues.add(attributeValue);
                });
                SRStatementGenerator.this.attributeValueList.add(attributeValues.toArray());
                SRStatementGenerator.this.tableDeviceIdList.add(Arrays.copyOfRange(path.getNodes(), 3, path.getNodeLength()));
                if (SRStatementGenerator.this.tableDeviceIdList.size() >= MAX_SCHEMA_BATCH_SIZE) {
                    SRStatementGenerator.this.emitDevice();
                }
            }
            return null;
        }
    }
}

