/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.table.v1.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.protocol.rest.table.v1.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.table.v1.model.SQL;
import org.apache.tsfile.enums.TSDataType;

public class RequestValidationHandler {
    private RequestValidationHandler() {
    }

    public static void validateSQL(SQL sql) {
        Objects.requireNonNull(sql.getSql(), "sql should not be null");
        if (sql.getRowLimit() != null) {
            Validate.isTrue((sql.getRowLimit() > 0 ? 1 : 0) != 0, (String)"row_limit should be positive", (Object[])new Object[0]);
        }
    }

    public static void validateInsertTabletRequest(InsertTabletRequest insertTabletRequest) {
        Objects.requireNonNull(insertTabletRequest.getDatabase(), "database should not be null");
        Objects.requireNonNull(insertTabletRequest.getTable(), "table should not be null");
        Objects.requireNonNull(insertTabletRequest.getColumnNames(), "column_names should not be null");
        Objects.requireNonNull(insertTabletRequest.getColumnCatogories(), "column_catogories should not be null");
        Objects.requireNonNull(insertTabletRequest.getDataTypes(), "data_types should not be null");
        Objects.requireNonNull(insertTabletRequest.getTimestamps(), "timestamps should not be null");
        Objects.requireNonNull(insertTabletRequest.getValues(), "values should not be null");
        ArrayList<String> errorMessages = new ArrayList<String>();
        String table = insertTabletRequest.getTable();
        if (insertTabletRequest.getColumnCatogories().size() == 0 || insertTabletRequest.getColumnCatogories().size() != insertTabletRequest.getColumnNames().size()) {
            errorMessages.add("column_names and column_catogories should have the same size");
        }
        if (insertTabletRequest.getColumnCatogories().size() != insertTabletRequest.getDataTypes().size()) {
            errorMessages.add("column_catogories and data_types should have the same size");
        }
        if (insertTabletRequest.getTimestamps().size() != insertTabletRequest.getValues().size()) {
            errorMessages.add("values and timestamps should have the same size");
        }
        for (int i = 0; i < insertTabletRequest.getDataTypes().size(); ++i) {
            String dataType = (String)insertTabletRequest.getDataTypes().get(i);
            if (!RequestValidationHandler.isDataType(dataType)) continue;
            errorMessages.add("The " + dataType + " data type of " + table + " is illegal");
        }
        int dataTypeSize = insertTabletRequest.getDataTypes().size();
        for (int i = 0; i < insertTabletRequest.getValues().size(); ++i) {
            List values = (List)insertTabletRequest.getValues().get(i);
            if (dataTypeSize == values.size()) continue;
            errorMessages.add("The number of values in the " + (i + 1) + "th row is not equal to the data_types size");
        }
        if (!errorMessages.isEmpty()) {
            throw new RuntimeException(String.join((CharSequence)",", errorMessages));
        }
    }

    private static boolean isDataType(String dataType) {
        try {
            TSDataType.valueOf((String)dataType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return false;
    }
}

