/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.page;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.tsfile.compress.ICompressor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.encrypt.IEncryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.EncryptionType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuePageWriter {
    private static final Logger logger = LoggerFactory.getLogger(ValuePageWriter.class);
    private final ICompressor compressor;
    private final EncryptParameter encryptParam;
    private Encoder valueEncoder;
    private final PublicBAOS valueOut = new PublicBAOS();
    private Statistics<? extends Serializable> statistics;
    private byte bitmap = 0;
    private int size = 0;
    private final PublicBAOS bitmapOut = new PublicBAOS();
    private static final int MASK = 128;

    public ValuePageWriter(Encoder valueEncoder, ICompressor compressor, TSDataType dataType) {
        this.valueEncoder = valueEncoder;
        this.statistics = Statistics.getStatsByType(dataType);
        this.compressor = compressor;
        this.encryptParam = EncryptUtils.getEncryptParameter();
    }

    public ValuePageWriter(Encoder valueEncoder, ICompressor compressor, TSDataType dataType, EncryptParameter encryptParam) {
        this.valueEncoder = valueEncoder;
        this.statistics = Statistics.getStatsByType(dataType);
        this.compressor = compressor;
        this.encryptParam = encryptParam;
    }

    public void write(long time, boolean value, boolean isNull) {
        this.setBit(isNull);
        if (!isNull) {
            this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(time, value);
        }
    }

    public void write(long time, short value, boolean isNull) {
        this.setBit(isNull);
        if (!isNull) {
            this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(time, (int)value);
        }
    }

    public void write(long time, int value, boolean isNull) {
        this.setBit(isNull);
        if (!isNull) {
            this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(time, value);
        }
    }

    public void write(long time, long value, boolean isNull) {
        this.setBit(isNull);
        if (!isNull) {
            this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(time, value);
        }
    }

    public void write(long time, float value, boolean isNull) {
        this.setBit(isNull);
        if (!isNull) {
            this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(time, value);
        }
    }

    public void write(long time, double value, boolean isNull) {
        this.setBit(isNull);
        if (!isNull) {
            this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(time, value);
        }
    }

    public void write(long time, Binary value, boolean isNull) {
        this.setBit(isNull);
        if (!isNull) {
            this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(time, value);
        }
    }

    private void setBit(boolean isNull) {
        if (!isNull) {
            this.bitmap = (byte)(this.bitmap | 128 >>> this.size % 8);
        }
        ++this.size;
        if (this.size % 8 == 0) {
            this.bitmapOut.write(this.bitmap);
            this.bitmap = 0;
        }
    }

    public void write(long[] timestamps, boolean[] values, boolean[] isNull, int batchSize, int arrayOffset) {
        for (int i = arrayOffset; i < batchSize + arrayOffset; ++i) {
            this.setBit(isNull[i]);
            if (isNull[i]) continue;
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(timestamps[i], values[i]);
        }
    }

    public void write(long[] timestamps, int[] values, boolean[] isNull, int batchSize, int arrayOffset) {
        for (int i = arrayOffset; i < batchSize + arrayOffset; ++i) {
            this.setBit(isNull[i]);
            if (isNull[i]) continue;
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(timestamps[i], values[i]);
        }
    }

    public void write(long[] timestamps, long[] values, boolean[] isNull, int batchSize, int arrayOffset) {
        for (int i = arrayOffset; i < batchSize + arrayOffset; ++i) {
            this.setBit(isNull[i]);
            if (isNull[i]) continue;
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(timestamps[i], values[i]);
        }
    }

    public void write(long[] timestamps, float[] values, boolean[] isNull, int batchSize, int arrayOffset) {
        for (int i = arrayOffset; i < batchSize + arrayOffset; ++i) {
            this.setBit(isNull[i]);
            if (isNull[i]) continue;
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(timestamps[i], values[i]);
        }
    }

    public void write(long[] timestamps, double[] values, boolean[] isNull, int batchSize, int arrayOffset) {
        for (int i = arrayOffset; i < batchSize + arrayOffset; ++i) {
            this.setBit(isNull[i]);
            if (isNull[i]) continue;
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(timestamps[i], values[i]);
        }
    }

    public void write(long[] timestamps, Binary[] values, boolean[] isNull, int batchSize, int arrayOffset) {
        for (int i = arrayOffset; i < batchSize + arrayOffset; ++i) {
            this.setBit(isNull[i]);
            if (isNull[i]) continue;
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
            this.statistics.update(timestamps[i], values[i]);
        }
    }

    private void prepareEndWriteOnePage() throws IOException {
        this.valueEncoder.flush(this.valueOut);
        if (this.size % 8 != 0) {
            this.bitmapOut.write(this.bitmap);
        }
    }

    public ByteBuffer getUncompressedBytes() throws IOException {
        this.prepareEndWriteOnePage();
        ByteBuffer buffer = ByteBuffer.allocate(4 + this.bitmapOut.size() + this.valueOut.size());
        buffer.putInt(this.size);
        buffer.put(this.bitmapOut.getBuf(), 0, this.bitmapOut.size());
        buffer.put(this.valueOut.getBuf(), 0, this.valueOut.size());
        buffer.flip();
        return buffer;
    }

    public int writeEmptyPageIntoBuff(PublicBAOS pageBuffer) {
        return ReadWriteForEncodingUtils.writeUnsignedVarInt(0, pageBuffer);
    }

    public int writePageHeaderAndDataIntoBuff(PublicBAOS pageBuffer, boolean first) throws IOException {
        int compressedSize;
        if (this.size == 0) {
            return 0;
        }
        if (this.statistics.getCount() == 0) {
            return this.writeEmptyPageIntoBuff(pageBuffer);
        }
        ByteBuffer pageData = this.getUncompressedBytes();
        int uncompressedSize = pageData.remaining();
        byte[] compressedBytes = null;
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            compressedSize = uncompressedSize;
        } else if (this.compressor.getType().equals((Object)CompressionType.GZIP)) {
            compressedBytes = this.compressor.compress(pageData.array(), pageData.position(), uncompressedSize);
            compressedSize = compressedBytes.length;
        } else {
            compressedBytes = new byte[this.compressor.getMaxBytesForCompression(uncompressedSize)];
            compressedSize = this.compressor.compress(pageData.array(), pageData.position(), uncompressedSize, compressedBytes);
        }
        int sizeWithoutStatistic = 0;
        if (first) {
            sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(uncompressedSize, pageBuffer);
            sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(compressedSize, pageBuffer);
        } else {
            ReadWriteForEncodingUtils.writeUnsignedVarInt(uncompressedSize, pageBuffer);
            ReadWriteForEncodingUtils.writeUnsignedVarInt(compressedSize, pageBuffer);
            this.statistics.serialize(pageBuffer);
        }
        IEncryptor encryptor = IEncryptor.getEncryptor(this.encryptParam);
        logger.trace("start to flush a page data into buffer, buffer position {} ", (Object)pageBuffer.size());
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            if (encryptor.getEncryptionType().equals((Object)EncryptionType.UNENCRYPTED)) {
                try (WritableByteChannel channel = Channels.newChannel(pageBuffer);){
                    channel.write(pageData);
                }
            } else {
                byte[] encryptedBytes = null;
                encryptedBytes = encryptor.encrypt(pageData.array(), pageData.position(), uncompressedSize);
                int encryptedSize = encryptedBytes.length;
                pageBuffer.write(encryptedBytes, 0, encryptedSize);
            }
        } else if (encryptor.getEncryptionType().equals((Object)EncryptionType.UNENCRYPTED)) {
            pageBuffer.write(compressedBytes, 0, compressedSize);
        } else {
            byte[] encryptedBytes = null;
            encryptedBytes = encryptor.encrypt(compressedBytes, 0, compressedSize);
            int encryptedSize = encryptedBytes.length;
            pageBuffer.write(encryptedBytes, 0, encryptedSize);
        }
        logger.trace("start to flush a page data into buffer, buffer position {} ", (Object)pageBuffer.size());
        return sizeWithoutStatistic;
    }

    public long estimateMaxMemSize() {
        return (long)(4 + this.bitmapOut.size() + 1 + this.valueOut.size()) + this.valueEncoder.getMaxByteSize();
    }

    public void reset(TSDataType dataType) {
        this.bitmapOut.reset();
        this.size = 0;
        this.bitmap = 0;
        this.valueOut.reset();
        this.statistics = Statistics.getStatsByType(dataType);
    }

    public void setValueEncoder(Encoder encoder) {
        this.valueEncoder = encoder;
    }

    public void initStatistics(TSDataType dataType) {
        this.statistics = Statistics.getStatsByType(dataType);
    }

    public long getPointNumber() {
        return this.statistics.getCount();
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }

    public int getSize() {
        return this.size;
    }
}

