/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.SnapshotRetentionPolicy;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.MD5FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStateMachineStorage
implements StateMachineStorage {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStateMachineStorage.class);
    static final String SNAPSHOT_FILE_PREFIX = "snapshot";
    static final String CORRUPT_SNAPSHOT_FILE_SUFFIX = ".corrupt";
    public static final Pattern SNAPSHOT_REGEX = Pattern.compile("snapshot\\.(\\d+)_(\\d+)");
    public static final Pattern SNAPSHOT_MD5_REGEX = Pattern.compile("snapshot\\.(\\d+)_(\\d+).md5");
    private static final DirectoryStream.Filter<Path> SNAPSHOT_MD5_FILTER = entry -> Optional.ofNullable(entry.getFileName()).map(Path::toString).map(SNAPSHOT_MD5_REGEX::matcher).filter(Matcher::matches).isPresent();
    private volatile File stateMachineDir = null;
    private final AtomicReference<SingleFileSnapshotInfo> latestSnapshot = new AtomicReference();

    public void init(RaftStorage storage) throws IOException {
        this.stateMachineDir = storage.getStorageDir().getStateMachineDir();
        this.getLatestSnapshot();
    }

    public void format() throws IOException {
    }

    static List<SingleFileSnapshotInfo> getSingleFileSnapshotInfos(Path dir) throws IOException {
        ArrayList<SingleFileSnapshotInfo> infos = new ArrayList<SingleFileSnapshotInfo>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                Matcher matcher;
                Path filename = path.getFileName();
                if (filename == null || !(matcher = SNAPSHOT_REGEX.matcher(filename.toString())).matches()) continue;
                long term = Long.parseLong(matcher.group(1));
                long index = Long.parseLong(matcher.group(2));
                FileInfo fileInfo = new FileInfo(path, null);
                infos.add(new SingleFileSnapshotInfo(fileInfo, term, index));
            }
        }
        return infos;
    }

    public void cleanupOldSnapshots(SnapshotRetentionPolicy snapshotRetentionPolicy) throws IOException {
        if (this.stateMachineDir == null) {
            return;
        }
        int numSnapshotsRetained = Optional.ofNullable(snapshotRetentionPolicy).map(SnapshotRetentionPolicy::getNumSnapshotsRetained).orElse(-1);
        if (numSnapshotsRetained <= 0) {
            return;
        }
        List<SingleFileSnapshotInfo> allSnapshotFiles = SimpleStateMachineStorage.getSingleFileSnapshotInfos(this.stateMachineDir.toPath());
        if (allSnapshotFiles.size() > numSnapshotsRetained) {
            allSnapshotFiles.sort(Comparator.comparing(SnapshotInfo::getIndex).reversed());
            allSnapshotFiles.subList(numSnapshotsRetained, allSnapshotFiles.size()).stream().map(SingleFileSnapshotInfo::getFile).map(FileInfo::getPath).forEach(snapshotPath -> {
                LOG.info("Deleting old snapshot at {}", (Object)snapshotPath.toAbsolutePath());
                FileUtils.deletePathQuietly((Path)snapshotPath);
            });
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.stateMachineDir.toPath(), SNAPSHOT_MD5_FILTER);){
                for (Path md5path : stream) {
                    String md5FileName;
                    File snapshotFile;
                    Path md5FileNamePath = md5path.getFileName();
                    if (md5FileNamePath == null || (snapshotFile = new File(this.stateMachineDir, (md5FileName = md5FileNamePath.toString()).substring(0, md5FileName.length() - ".md5".length()))).exists()) continue;
                    FileUtils.deletePathQuietly((Path)md5path);
                }
            }
        }
    }

    public static TermIndex getTermIndexFromSnapshotFile(File file) {
        String name = file.getName();
        Matcher m = SNAPSHOT_REGEX.matcher(name);
        if (!m.matches()) {
            throw new IllegalArgumentException("File \"" + file + "\" does not match snapshot file name pattern \"" + SNAPSHOT_REGEX + "\"");
        }
        long term = Long.parseLong(m.group(1));
        long index = Long.parseLong(m.group(2));
        return TermIndex.valueOf((long)term, (long)index);
    }

    protected static String getTmpSnapshotFileName(long term, long endIndex) {
        return SimpleStateMachineStorage.getSnapshotFileName(term, endIndex) + ".tmp";
    }

    protected static String getCorruptSnapshotFileName(long term, long endIndex) {
        return SimpleStateMachineStorage.getSnapshotFileName(term, endIndex) + CORRUPT_SNAPSHOT_FILE_SUFFIX;
    }

    public File getSnapshotFile(long term, long endIndex) {
        File dir = Objects.requireNonNull(this.stateMachineDir, "stateMachineDir == null");
        return new File(dir, SimpleStateMachineStorage.getSnapshotFileName(term, endIndex));
    }

    protected File getTmpSnapshotFile(long term, long endIndex) {
        File dir = Objects.requireNonNull(this.stateMachineDir, "stateMachineDir == null");
        return new File(dir, SimpleStateMachineStorage.getTmpSnapshotFileName(term, endIndex));
    }

    protected File getCorruptSnapshotFile(long term, long endIndex) {
        File dir = Objects.requireNonNull(this.stateMachineDir, "stateMachineDir == null");
        return new File(dir, SimpleStateMachineStorage.getCorruptSnapshotFileName(term, endIndex));
    }

    static SingleFileSnapshotInfo findLatestSnapshot(Path dir) throws IOException {
        Iterator<SingleFileSnapshotInfo> i = SimpleStateMachineStorage.getSingleFileSnapshotInfos(dir).iterator();
        if (!i.hasNext()) {
            return null;
        }
        SingleFileSnapshotInfo latest = i.next();
        while (i.hasNext()) {
            SingleFileSnapshotInfo info = i.next();
            if (info.getIndex() <= latest.getIndex()) continue;
            latest = info;
        }
        Path path = latest.getFile().getPath();
        MD5Hash md5 = MD5FileUtil.readStoredMd5ForFile((File)path.toFile());
        FileInfo info = new FileInfo(path, md5);
        return new SingleFileSnapshotInfo(info, latest.getTerm(), latest.getIndex());
    }

    public SingleFileSnapshotInfo updateLatestSnapshot(SingleFileSnapshotInfo info) {
        return this.latestSnapshot.updateAndGet(previous -> previous == null || info.getIndex() > previous.getIndex() ? info : previous);
    }

    public static String getSnapshotFileName(long term, long endIndex) {
        return "snapshot." + term + "_" + endIndex;
    }

    public SingleFileSnapshotInfo getLatestSnapshot() {
        SingleFileSnapshotInfo s = this.latestSnapshot.get();
        if (s != null) {
            return s;
        }
        return this.loadLatestSnapshot();
    }

    public SingleFileSnapshotInfo loadLatestSnapshot() {
        File dir = this.stateMachineDir;
        if (dir == null) {
            return null;
        }
        try {
            return this.updateLatestSnapshot(SimpleStateMachineStorage.findLatestSnapshot(dir.toPath()));
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @VisibleForTesting
    File getStateMachineDir() {
        return this.stateMachineDir;
    }
}

