/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.flush;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.flush.pool.FlushSubTaskPoolManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemTableFlushTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemTableFlushTask.class);
    private static final FlushSubTaskPoolManager SUB_TASK_POOL_MANAGER = FlushSubTaskPoolManager.getInstance();
    private static final WritingMetrics WRITING_METRICS = WritingMetrics.getInstance();
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final int MAX_NUMBER_OF_POINTS_IN_PAGE = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
    private static final Map<String, Long> flushPointsCache = new ConcurrentHashMap<String, Long>();
    private final Future<?> encodingTaskFuture;
    private final Future<?> ioTaskFuture;
    private RestorableTsFileIOWriter writer;
    private final BlockingQueue<Object> encodingTaskQueue = new LinkedBlockingQueue<Object>();
    private final BlockingQueue<Object> ioTaskQueue = SystemInfo.getInstance().isEncodingFasterThanIo() ? new LinkedBlockingQueue(config.getIoTaskQueueSizeForFlushing()) : new LinkedBlockingQueue();
    private String storageGroup;
    private String dataRegionId;
    private IMemTable memTable;
    private volatile long memSerializeTime = 0L;
    private volatile long ioTime = 0L;
    private final BatchEncodeInfo encodeInfo;
    private long[] times;
    private Runnable encodingTask = new Runnable(){

        @Override
        public void run() {
            LOGGER.debug("Database {} memtable flushing to file {} starts to encoding data.", (Object)MemTableFlushTask.this.storageGroup, (Object)MemTableFlushTask.this.writer.getFile().getName());
            while (true) {
                Object task;
                try {
                    task = MemTableFlushTask.this.encodingTaskQueue.take();
                }
                catch (InterruptedException e1) {
                    LOGGER.error("Take task into ioTaskQueue Interrupted");
                    Thread.currentThread().interrupt();
                    break;
                }
                if (task instanceof StartFlushGroupIOTask || task instanceof EndChunkGroupIoTask) {
                    try {
                        MemTableFlushTask.this.ioTaskQueue.put(task);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Database {} memtable flushing to file {}, encoding task is interrupted.", new Object[]{MemTableFlushTask.this.storageGroup, MemTableFlushTask.this.writer.getFile().getName(), e});
                        break;
                    }
                }
                if (task instanceof TaskEnd) break;
                long starTime = System.currentTimeMillis();
                IWritableMemChunk writableMemChunk = (IWritableMemChunk)task;
                if (writableMemChunk instanceof AlignedWritableMemChunk && MemTableFlushTask.this.times == null) {
                    MemTableFlushTask.access$502(MemTableFlushTask.this, new long[MemTableFlushTask.this.MAX_NUMBER_OF_POINTS_IN_PAGE]);
                }
                writableMemChunk.encode(MemTableFlushTask.this.ioTaskQueue, MemTableFlushTask.this.encodeInfo, MemTableFlushTask.this.times);
                long subTaskTime = System.currentTimeMillis() - starTime;
                WRITING_METRICS.recordFlushSubTaskCost("encoding_task", subTaskTime);
                MemTableFlushTask.this.memSerializeTime += subTaskTime;
            }
            try {
                MemTableFlushTask.this.ioTaskQueue.put(new TaskEnd());
            }
            catch (InterruptedException e) {
                LOGGER.error("Put task into ioTaskQueue Interrupted");
                Thread.currentThread().interrupt();
            }
            DataRegion.getNonSystemDatabaseName(MemTableFlushTask.this.storageGroup).ifPresent(databaseName -> MemTableFlushTask.recordFlushPointsMetricInternal(MemTableFlushTask.this.memTable.getTotalPointsNum(), databaseName, MemTableFlushTask.this.dataRegionId));
            WRITING_METRICS.recordFlushCost("encoding", MemTableFlushTask.this.memSerializeTime);
        }
    };
    private Runnable ioTask = () -> {
        LOGGER.debug("Database {} memtable flushing to file {} start io.", (Object)this.storageGroup, (Object)this.writer.getFile().getName());
        while (true) {
            Object ioMessage = null;
            try {
                ioMessage = this.ioTaskQueue.take();
            }
            catch (InterruptedException e1) {
                LOGGER.error("take task from ioTaskQueue Interrupted");
                Thread.currentThread().interrupt();
                break;
            }
            long starTime = System.currentTimeMillis();
            try {
                if (ioMessage instanceof StartFlushGroupIOTask) {
                    this.writer.startChunkGroup(((StartFlushGroupIOTask)ioMessage).deviceId);
                } else {
                    if (ioMessage instanceof TaskEnd) break;
                    if (ioMessage instanceof EndChunkGroupIoTask) {
                        this.writer.setMinPlanIndex(this.memTable.getMinPlanIndex());
                        this.writer.setMaxPlanIndex(this.memTable.getMaxPlanIndex());
                        this.writer.endChunkGroup();
                    } else {
                        ((IChunkWriter)ioMessage).writeToFileWriter((TsFileIOWriter)this.writer);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Database {} memtable {}, io task meets error.", new Object[]{this.storageGroup, this.memTable, e});
                return;
            }
            long subTaskTime = System.currentTimeMillis() - starTime;
            this.ioTime += subTaskTime;
            WRITING_METRICS.recordFlushSubTaskCost("io_task", subTaskTime);
        }
        LOGGER.debug("flushing a memtable to file {} in database {}, io cost {}ms", new Object[]{this.writer.getFile().getName(), this.storageGroup, this.ioTime});
        WRITING_METRICS.recordFlushTsFileSize(this.storageGroup, this.writer.getFile().length());
        WRITING_METRICS.recordFlushCost("io", this.ioTime);
    };

    public MemTableFlushTask(IMemTable memTable, RestorableTsFileIOWriter writer, String storageGroup, String dataRegionId) {
        this.memTable = memTable;
        this.writer = writer;
        this.storageGroup = storageGroup;
        this.dataRegionId = dataRegionId;
        this.encodingTaskFuture = SUB_TASK_POOL_MANAGER.submit(this.encodingTask);
        this.ioTaskFuture = SUB_TASK_POOL_MANAGER.submit(this.ioTask);
        this.encodeInfo = new BatchEncodeInfo(0, 0, 0L);
        LOGGER.debug("flush task of database {} memtable is created, flushing to file {}.", (Object)storageGroup, (Object)writer.getFile().getName());
    }

    public void syncFlushMemTable() throws ExecutionException, InterruptedException {
        long avgSeriesPointsNum = this.memTable.getSeriesNumber() == 0 ? 0L : this.memTable.getTotalPointsNum() / (long)this.memTable.getSeriesNumber();
        WRITING_METRICS.recordFlushingMemTableStatus(this.storageGroup, this.memTable.memSize(), this.memTable.getSeriesNumber(), this.memTable.getTotalPointsNum(), avgSeriesPointsNum);
        long estimatedTemporaryMemSize = 0L;
        if (SystemInfo.getInstance().isEncodingFasterThanIo()) {
            estimatedTemporaryMemSize = this.memTable.getSeriesNumber() == 0 ? 0L : this.memTable.memSize() / (long)this.memTable.getSeriesNumber() * (long)config.getIoTaskQueueSizeForFlushing();
            SystemInfo.getInstance().applyTemporaryMemoryForFlushing(estimatedTemporaryMemSize);
        }
        long start = System.currentTimeMillis();
        long sortTime = 0L;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = this.memTable.getMemTableMap();
        ArrayList<IDeviceID> deviceIDList = new ArrayList<IDeviceID>(memTableMap.keySet());
        Collections.sort(deviceIDList);
        for (IDeviceID deviceID : deviceIDList) {
            Map<String, IWritableMemChunk> value = memTableMap.get(deviceID).getMemChunkMap();
            if (memTableMap.get(deviceID).count() == 0L || value.isEmpty()) continue;
            this.encodingTaskQueue.put(new StartFlushGroupIOTask(deviceID));
            ArrayList<String> seriesInOrder = new ArrayList<String>(value.keySet());
            Collections.sort(seriesInOrder);
            for (String seriesId : seriesInOrder) {
                long startTime = System.currentTimeMillis();
                IWritableMemChunk series = value.get(seriesId);
                if (series.count() == 0L) continue;
                series.sortTvListForFlush();
                long subTaskTime = System.currentTimeMillis() - startTime;
                sortTime += subTaskTime;
                WRITING_METRICS.recordFlushSubTaskCost("sort_task", subTaskTime);
                this.encodingTaskQueue.put(series);
            }
            this.encodingTaskQueue.put(new EndChunkGroupIoTask());
        }
        this.encodingTaskQueue.put(new TaskEnd());
        LOGGER.debug("Database {} memtable flushing into file {}: data sort time cost {} ms.", new Object[]{this.storageGroup, this.writer.getFile().getName(), sortTime});
        WRITING_METRICS.recordFlushCost("sort", sortTime);
        try {
            this.encodingTaskFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.ioTaskFuture.cancel(true);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
        this.ioTaskFuture.get();
        try {
            long writePlanIndicesStartTime = System.currentTimeMillis();
            this.writer.writePlanIndices();
            WRITING_METRICS.recordFlushCost("write_plan_indices", System.currentTimeMillis() - writePlanIndicesStartTime);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        if (estimatedTemporaryMemSize != 0L) {
            SystemInfo.getInstance().releaseTemporaryMemoryForFlushing(estimatedTemporaryMemSize);
        }
        SystemInfo.getInstance().setEncodingFasterThanIo(this.ioTime >= this.memSerializeTime);
        MetricService.getInstance().timer(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "flush"});
    }

    public static void recordFlushPointsMetricInternal(long totalPointsNum, String storageGroupName, String dataRegionId) {
        long currentTime = CommonDateTimeUtils.currentTime();
        long writeTime = flushPointsCache.compute(storageGroupName, (storageGroup, lastTime) -> {
            if (lastTime == null || lastTime != currentTime) {
                return currentTime;
            }
            return currentTime + 1L;
        });
        MetricService.getInstance().gaugeWithInternalReportAsync(totalPointsNum, Metric.POINTS.toString(), MetricLevel.CORE, writeTime, new String[]{Tag.DATABASE.toString(), storageGroupName, Tag.TYPE.toString(), "flush", Tag.REGION.toString(), dataRegionId});
    }

    static /* synthetic */ long[] access$502(MemTableFlushTask x0, long[] x1) {
        x0.times = x1;
        return x1;
    }

    static class StartFlushGroupIOTask {
        private final IDeviceID deviceId;

        StartFlushGroupIOTask(IDeviceID deviceId) {
            this.deviceId = deviceId;
        }
    }

    static class EndChunkGroupIoTask {
        EndChunkGroupIoTask() {
        }
    }

    static class TaskEnd {
        TaskEnd() {
        }
    }
}

