/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;

public class RepairTimePartition {
    private final String databaseName;
    private final String dataRegionId;
    private TsFileManager tsFileManager;
    private final long timePartitionId;
    private long maxFileTimestamp;
    private boolean repaired;

    public RepairTimePartition(DataRegion dataRegion, long timePartitionId, long maxFileTimestamp) {
        this.databaseName = dataRegion.getDatabaseName();
        this.dataRegionId = dataRegion.getDataRegionId();
        this.tsFileManager = dataRegion.getTsFileManager();
        this.timePartitionId = timePartitionId;
        this.maxFileTimestamp = maxFileTimestamp;
        this.repaired = false;
    }

    public RepairTimePartition(String databaseName, String dataRegionId, long timePartitionId) {
        this.databaseName = databaseName;
        this.dataRegionId = dataRegionId;
        this.timePartitionId = timePartitionId;
    }

    public long getTimePartitionId() {
        return this.timePartitionId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public TsFileManager getTsFileManager() {
        return this.tsFileManager;
    }

    public boolean isRepaired() {
        return this.repaired;
    }

    public void setRepaired(boolean repaired) {
        this.repaired = repaired;
    }

    public boolean needRepair() {
        return !this.getAllFileSnapshot().isEmpty();
    }

    public List<TsFileResource> getSeqFileSnapshot() {
        return this.tsFileManager.getTsFileListSnapshot(this.timePartitionId, true).stream().filter(this::resourceTimestampFilter).collect(Collectors.toList());
    }

    public List<TsFileResource> getUnSeqFileSnapshot() {
        return this.tsFileManager.getTsFileListSnapshot(this.timePartitionId, false).stream().filter(this::resourceTimestampFilter).collect(Collectors.toList());
    }

    public List<TsFileResource> getAllFileSnapshot() {
        List<TsFileResource> seqFiles = this.getSeqFileSnapshot();
        List<TsFileResource> unseqFiles = this.getUnSeqFileSnapshot();
        ArrayList<TsFileResource> allFiles = new ArrayList<TsFileResource>(seqFiles.size() + unseqFiles.size());
        allFiles.addAll(seqFiles);
        allFiles.addAll(unseqFiles);
        return allFiles;
    }

    private boolean resourceTimestampFilter(TsFileResource resource) {
        if (resource.getStatus() == TsFileResourceStatus.DELETED || resource.getStatus() == TsFileResourceStatus.UNCLOSED) {
            return false;
        }
        long fileTimestamp = this.getFileTimestamp(resource);
        return fileTimestamp >= 0L && fileTimestamp <= this.maxFileTimestamp;
    }

    private long getFileTimestamp(TsFileResource resource) {
        long timestamp = -1L;
        try {
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            timestamp = tsFileName.getTime();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairTimePartition that = (RepairTimePartition)o;
        return this.timePartitionId == that.timePartitionId && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.dataRegionId, that.dataRegionId);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.dataRegionId, this.timePartitionId);
    }
}

