/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.function.UnaryOperator;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.GroupByLevelHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReconstructVisitor;

public class ReplaceRawPathWithGroupedPathVisitor
extends ReconstructVisitor<Context> {
    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Context context) {
        PartialPath rawPath = timeSeriesOperand.getPath();
        PartialPath groupedPath = context.transform(rawPath);
        return ExpressionUtils.reconstructTimeSeriesOperand(timeSeriesOperand, groupedPath);
    }

    @Override
    public Expression visitTimeStampOperand(TimestampOperand timestampOperand, Context context) {
        return timestampOperand;
    }

    @Override
    public Expression visitConstantOperand(ConstantOperand constantOperand, Context context) {
        return constantOperand;
    }

    public static class Context {
        private final GroupByLevelHelper.RawPathToGroupedPathMap rawPathToGroupedPathMap;
        private final UnaryOperator<PartialPath> pathTransformer;

        public Context(GroupByLevelHelper.RawPathToGroupedPathMap rawPathToGroupedPathMap, UnaryOperator<PartialPath> pathTransformer) {
            this.rawPathToGroupedPathMap = rawPathToGroupedPathMap;
            this.pathTransformer = pathTransformer;
        }

        private PartialPath transform(PartialPath path) {
            if (this.rawPathToGroupedPathMap.containsKey(path)) {
                return this.rawPathToGroupedPathMap.get(path);
            }
            PartialPath groupedPath = (PartialPath)this.pathTransformer.apply(path);
            this.rawPathToGroupedPathMap.put(path, groupedPath);
            return groupedPath;
        }
    }
}

