/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { ILocale } from './index.d';

const zhCn: ILocale = {
  MenuRouter: {
    overview: '概览',
    transactionInfo: '事务信息',
    globalLockInfo: '全局锁信息',
    clusterManager: '集群管理',
    sagaStatemachineDesigner: 'Saga状态机设计器',
  },
  Header: {
    home: '首页',
    docs: '文档',
    blog: '博客',
    community: '社区',
    download: '下载',
    languageSwitchButton: 'En',
    logout: '登出',
  },
  Login: {
    login: '登录',
    submit: '提交',
    pleaseInputUsername: '请输入用户名',
    pleaseInputPassword: '请输入密码',
    invalidUsernameOrPassword: '用户名或密码错误',
    passwordRequired: '密码不能为空',
    usernameRequired: '用户名不能为空',
    desc: 'Seata 是一款开源的分布式事务解决方案，致力于在微服务架构下提供高性能和简单易用的分布式事务服务。',
  },
  Overview: {
    title: '概览',
    subTitle: '基础列表页',
    search: '搜索',
  },
  TransactionInfo: {
    title: '事务信息',
    subTitle: '基础列表页',
    createTimeLabel: '创建时间',
    selectFilerPlaceholder: '请选择筛选条件',
    selectNamespaceFilerPlaceholder: '请选择命名空间',
    selectClusterFilerPlaceholder: '请选择集群',
    selectVGroupFilerPlaceholder: '请选择事务分组',
    inputFilterPlaceholder: '请输入筛选条件',
    branchSessionSwitchLabel: '是否包含分支事务',
    resetButtonLabel: '重置',
    searchButtonLabel: '搜索',
    operateTitle: '操作',
    showBranchSessionTitle: '查看分支信息',
    showGlobalLockTitle: '查看全局锁',
    branchSessionDialogTitle: '分支事务信息',
    deleteGlobalSessionTitle: '删除全局事务',
    forceDeleteGlobalSessionTitle: '强制删除全局事务',
    stopGlobalSessionTitle: '停止全局事务重试',
    startGlobalSessionTitle: '开启全局事务重试',
    sendGlobalSessionTitle: '提交或回滚全局事务',
    changeGlobalSessionTitle: '更新全局事务状态',
    deleteBranchSessionTitle: '删除分支事务',
    forceDeleteBranchSessionTitle: '强制删除分支事务',
    stopBranchSessionTitle: '停止分支事务重启',
    startBranchSessionTitle: '开启分支事务重试',
    createVGroupButtonLabel: '创建事务分组',
    createVGroupDialogTitle: '创建事务分组',
    createVGroupInputPlaceholder: '请输入事务分组名称',
    createVGroupConfirmButton: '创建',
    createVGroupErrorMessage: '请选择命名空间、集群并输入事务分组名称',
    createVGroupSuccessMessage: '事务分组创建成功',
    createVGroupFailMessage: '创建事务分组失败',
    changeVGroupButtonLabel: '修改事务分组',
    changeVGroupDialogTitle: '修改事务分组',
    changeVGroupSuccessMessage: '事务分组修改成功',
    changeVGroupFailMessage: '修改事务分组失败',
    namespaceLabel: '命名空间',
    clusterLabel: '集群',
    originalNamespaceLabel: '原命名空间',
    originalClusterLabel: '原集群',
    selectVGroupLabel: '选择事务分组',
    targetNamespaceLabel: '目标命名空间',
    targetClusterLabel: '目标集群',
    vGroupNameLabel: '事务分组名称',
    confirmButtonLabel: '确认',
    selectOriginalNamespacePlaceholder: '选择原命名空间',
    selectOriginalClusterPlaceholder: '选择原集群',
    selectTargetNamespacePlaceholder: '选择目标命名空间',
    selectTargetClusterPlaceholder: '选择目标集群',
    selectVGroupPlaceholder: '选择事务分组',
  },
  GlobalLockInfo: {
    title: '全局锁信息',
    subTitle: '基础列表页',
    createTimeLabel: '创建时间',
    inputFilterPlaceholder: '请输入筛选条件',
    selectNamespaceFilerPlaceholder: '请选择命名空间',
    selectClusterFilerPlaceholder: '请选择集群',
    selectVGroupFilerPlaceholder: '请选择事务分组',
    resetButtonLabel: '重置',
    searchButtonLabel: '搜索',
    operateTitle: '操作',
    deleteGlobalLockTitle: '删除全局锁',
  },
  ClusterManager: {
    title: '集群管理',
    subTitle: '集群节点管理',
    selectNamespaceFilerPlaceholder: '请选择命名空间',
    selectClusterFilerPlaceholder: '请选择集群',
    searchButtonLabel: '查询',
    unitName: '单元名称',
    members: '成员数',
    clusterType: '集群类型',
    view: '查看',
    unitDialogTitle: '单元详情',
    control: '控制地址',
    transaction: '事务地址',
    weight: '权重',
    healthy: '健康状态',
    term: '任期',
    role: '角色',
    unit: '单元',
    operations: '操作',
    internal: '内部地址',
    version: '版本',
    metadata: '元数据',
    controlEndpoint: '控制端点',
    transactionEndpoint: '事务端点',
    metadataDialogTitle: '元数据',
  },
  codeMessage: {
    200: '服务器成功返回请求的数据。',
    201: '新建或修改数据成功。',
    202: '一个请求已经进入后台排队（异步任务）。',
    204: '删除数据成功。',
    400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
    401: '用户没有权限（令牌、用户名、密码错误）。',
    403: '用户得到授权，但是访问是被禁止的。',
    404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
    406: '请求的格式不可得。',
    410: '请求的资源被永久删除，且不会再得到的。',
    422: '当创建一个对象时，发生一个验证错误。',
    500: '服务器发生错误，请检查服务器。',
    502: '网关错误。',
    503: '服务不可用，服务器暂时过载或维护。',
    504: '网关超时。',
    '-1000': '项目名称已存在，请使用其他名称。',
  },
};

export default zhCn;
