<!--
    Licensed to the Apache Software Foundation (ASF) under one or more
    contributor license agreements.  See the NOTICE file distributed with
    this work for additional information regarding copyright ownership.
    The ASF licenses this file to You under the Apache License, Version 2.0
    (the "License"); you may not use this file except in compliance with
    the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
-->
所有提交到 2.x 分支的 PR 请在此处登记。

<!-- 请根据PR的类型添加 `变更记录` 到以下对应位置(feature/bugfix/optimize/test) 下 -->

### feature:

- [[#7485](https://github.com/apache/incubator-seata/pull/7485)] 给seata-server端的http请求添加过滤器
- [[#7509](https://github.com/apache/incubator-seata/pull/7509)] 复用连接合并分支事务
- [[#7492](https://github.com/apache/incubator-seata/pull/7492)] 升级 common 模块中的 HTTP 客户端以支持 HTTP/2
- [[#7503](https://github.com/apache/incubator-seata/pull/7503)] 支持fory序列化
- [[#7551](https://github.com/apache/incubator-seata/pull/7551)] XAUtils支持达梦数据库
- [[#7559](https://github.com/apache/incubator-seata/pull/7559)] 为 TableMetaRefreshHolder 实例引入清理 API
- [[#7669](https://github.com/apache/incubator-seata/pull/7669)] 添加对 Jackson 序列化和反序列化 PostgreSQL 数组类型的支持
- [[#7664](https://github.com/apache/incubator-seata/pull/7565)] 支持神通数据库的XA模式
- [[#7675](https://github.com/apache/incubator-seata/pull/7675)] 支持Oracle批量插入
- [[#7663](https://github.com/apache/incubator-seata/pull/7663)] 支持java25版本的CI流水线
- [[#7851](https://github.com/apache/incubator-seata/pull/7851)] 控制台支持事务分组管理能力
- [[#7857](https://github.com/apache/incubator-seata/pull/7857)] 控制台支持集群信息展示
- [[#7826](https://github.com/apache/incubator-seata/pull/7826)] 在 Server Raft 模式下，为 Watch API 提供对 HTTP/2 响应处理的支持
- [[#7863](https://github.com/apache/incubator-seata/pull/7863)] JDK25以下workflow不构建naming server和console模块
- [[#7870](https://github.com/apache/incubator-seata/pull/7870)] 将namingserver和console模块升级到JDK 25和SpringBoot 3.5, 并在console模块中添加spring-ai依赖。
- [[#7872](https://github.com/apache/incubator-seata/pull/7872)] 根据当前内存值自动计算 JVM 参数
- [[#7876](https://github.com/apache/incubator-seata/pull/7876)] feature: 添加MCP服务自定义配置属性和鉴权功能
- [[#7878](https://github.com/apache/incubator-seata/pull/7878)] 控制台支持raft集群模式的事务分组管理
- [[#7893](https://github.com/apache/incubator-seata/pull/7893)] 添加全局和分支事务及锁管理MCP工具


### bugfix:

- [[#7471](https://github.com/apache/seata/issues/7471)] 修复SerialArray equals()方法在二阶段回滚中多维数组比较的问题
- [[#7482](https://github.com/apache/incubator-seata/pull/7482)] Github Action 工作流未运行相应的 Kotlin 测试
- [[#7538](https://github.com/apache/incubator-seata/pull/7538)] 统一DmdbTimestamp比较方式，通过UTC比较，以防止回滚失败
- [[#7546](https://github.com/seata/seata/pull/7546)] 修复客户端spring版本兼容
- [[#7505](https://github.com/apache/incubator-seata/pull/7505)] 通过使用 reconnectExecutor 异步释放 channel，防止阻塞 Netty I/O 线程
- [[#7563](https://github.com/apache/incubator-seata/pull/7563)] 修复在未开启服务端过滤器的状态下导致的过滤器链空指针异常
- [[#7570](https://github.com/apache/incubator-seata/pull/7570)] 修复 GlobalTransactionalInterceptorHandler 中的 order() 方法行为，确保拦截器的正确排序
- [[#7596](https://github.com/apache/incubator-seata/pull/7596)] 修复xss过滤器获取默认关键字时反序列化失败的问题
- [[#7613](https://github.com/apache/incubator-seata/pull/7613)] 修复全局锁查询中的datetime时间格式时间查询sql错误
- [[#7622](https://github.com/seata/seata/pull/7622)] 调整org.apache.seata.saga.rm.SagaResourceManage加载顺序
- [[#7624](https://github.com/apache/incubator-seata/pull/7624)] 修复yml配置文件中对于整数的兼容问题
- [[#7644](https://github.com/apache/incubator-seata/pull/7644)] 修复JAVA25时spotless的兼容性问题
- [[#7662](https://github.com/apache/incubator-seata/pull/7662)] 确保 rm 的可见性，并且 MockTest 中的方法按顺序执行
- [[#7683](https://github.com/apache/incubator-seata/pull/7683)] 重写 XABranchXid的equals和hashCode,解决mysql driver内存泄漏问题
- [[#7643](https://github.com/apache/incubator-seata/pull/7643)] 修复 DM 事务回滚不使用数据库自动增量主键
- [[#7708](https://github.com/apache/incubator-seata/pull/7708)] 使用xaActive判断xaResource是否需要执行end方法
- [[#7747](https://github.com/apache/incubator-seata/pull/7747)] 支持undo_log序列名动态推导
- [[#7749](https://github.com/apache/incubator-seata/pull/7749)] 修复 Http2HttpHandler 解析 application/x-www-form-urlencoded 请求失败的问题
- [[#7761](https://github.com/apache/incubator-seata/pull/7761)] 对 Byte[] 类型进行了特殊处理，以确保主键值正确
- [[#7771](https://github.com/apache/incubator-seata/pull/7771)] 确保神通XA模式相同的事务使用相同的XAConnection
- [[#7785](https://github.com/apache/incubator-seata/pull/7785)] 修复失败的测试方法
- [[#7796](https://github.com/apache/incubator-seata/pull/7796)] 修复 Consul 监听器空值 NPE 问题
- [[#7839](https://github.com/apache/incubator-seata/pull/7839)] 解决TransactionAutoConfiguration与Spring Boot 4.x的兼容性问题
- [[#7843](https://github.com/apache/incubator-seata/pull/7843)] 修复 Dm/KingbaseTableMetaCache 中的索引类型误判问题
- [[#7856](https://github.com/apache/incubator-seata/pull/7856)] 修复package.json中min-document的逗号缺失
- [[#7860](https://github.com/apache/incubator-seata/pull/7860)] 修复 RocketMQ 事务中延迟消息静默失效的问题，改为显式抛出异常
- [[#7879](https://github.com/apache/incubator-seata/pull/7879)] 修正服务器端口与命名服务器端口
- [[#7881](https://github.com/apache/incubator-seata/pull/7881)] 修复了除mysql之外其他数据库的sql文件关于vgroup_table的表，使用三列唯一索引以保证容灾迁移高可用
- [[#7891](https://github.com/apache/incubator-seata/pull/7891)] 修复raft重选举与心跳并发时可能导致namingserver侧的元数据存在多个leader
- [[#7908](https://github.com/apache/incubator-seata/pull/7908)] 在 PostgreSQL 主键中处理带时区的时间戳
- [[#7938](https://github.com/apache/incubator-seata/pull/7938)] 保证Jakarta相关包路径正确
- [[#7959](https://github.com/apache/incubator-seata/pull/7959)] 修复consoleApiService bean未加载的问题
- [[#7966](https://github.com/apache/incubator-seata/pull/7966)] 修复dm和kingbase中因列顺序不同导致索引未被识别为主键索引的问题


### optimize:

- [[#7460](https://github.com/apache/incubator-seata/pull/7460)] 移除 core 模块测试类中的硬编码端口配置
- [[#7478](https://github.com/apache/incubator-seata/pull/7484)] 删除client id指标
- [[#7557](https://github.com/seata/seata/pull/7557)] 升级 npmjs 依赖
- [[#7576](https://github.com/seata/seata/pull/7576)] 针对配置变更增加空推保护
- [[#7577](https://github.com/seata/seata/pull/7577)]  去除zstd解压时4MB的限制
- [[#7591](https://github.com/seata/seata/pull/7591)]  当没有显式配置xssFilter相关的配置时，优化获取默认配置的逻辑
- [[#7608](https://github.com/seata/seata/pull/7608)]  修改refreshToken方法中的参数名称
- [[#7603](https://github.com/seata/seata/pull/7603)] 将Apache Tomcat依赖项从9.0.106升级到9.0.108
- [[#7614](https://github.com/seata/seata/pull/7614)] 更新 README.md
- [[#7443](https://github.com/seata/seata/pull/7443)] 将saga注释模式中的@LocalTCC替换为@SagaTransactional
- [[#7645](https://github.com/seata/seata/pull/7645)] 简化相关的 transport.* 配置项类型
- [[#7668](https://github.com/seata/seata/pull/7668)] 优化DeflaterUtil变量名称
- [[#7673](https://github.com/apache/incubator-seata/pull/7673)] 升级 @babel/runtime ^7.26.10 到 ^7.27.0
- [[#7689](https://github.com/apache/incubator-seata/pull/7689)] 优化 source release
- [[#7711](https://github.com/apache/incubator-seata/pull/7711)] 添加 fastjson 对 PostgreSQL 数组类型的序列化和反序列化的支持
- [[#7722](https://github.com/apache/incubator-seata/pull/7722)] 优化 SerializerType 枚举含义
- [[#7739](https://github.com/apache/incubator-seata/pull/7739)] 优化 docker 镜像构建
- [[#7741](https://github.com/apache/incubator-seata/pull/7741)] 支持发布基于JDK 25的镜像
- [[#7743](https://github.com/seata/seata/pull/7743)] 将 Apache Tomcat 依赖项从 9.0.108 升级到 9.0.109
- [[#7740](https://github.com/apache/incubator-seata/pull/7740)] 优化http工具类使之支持h2c协议
- [[#7744](https://github.com/apache/incubator-seata/pull/7744)] 将 Apache Tomcat 依赖项从 9.0.109 升级到 9.0.110
- [[#7751](https://github.com/apache/incubator-seata/pull/7751)] 移除无用依赖
- [[#7807](https://github.com/apache/incubator-seata/pull/7807)] 支持 mariadb 3.x
- [[#7781](https://github.com/apache/incubator-seata/pull/7781)] 高亮 pmd 检查日志信息
- [[#7704](https://github.com/apache/incubator-seata/pull/7704)] 修复前端依赖漏洞
- [[#7710](https://github.com/apache/incubator-seata/pull/7710)] 修复语法拼写错误
- [[#7721](https://github.com/apache/incubator-seata/pull/7721)] 优化common 模块
- [[#7768](https://github.com/apache/incubator-seata/pull/7768)] 优化 docker 镜像构建
- [[#7809](https://github.com/apache/incubator-seata/pull/7809)] 优化 README.md
- [[#7813](https://github.com/apache/incubator-seata/pull/7813)] 增加解码buffer限制
- [[#7822](https://github.com/apache/incubator-seata/pull/7822)] 在 HTTP 线程上下文中添加请求和响应对象
- [[#7829](https://github.com/apache/incubator-seata/pull/7829)] 优化lz4 compressor
- [[#7864](https://github.com/apache/incubator-seata/pull/7864)] 自动跳过JDK<25环境下的console和namingserver模块编译
- [[#7867](https://github.com/apache/incubator-seata/pull/7867)] 优化全局事务注解支持非private修饰符方法
- [[#7868](https://github.com/apache/incubator-seata/pull/7868)] 将build_arm64-binary的CI更改为JDK25版本，并运行于ubuntu-24.04-arm
- [[#7873](https://github.com/apache/incubator-seata/pull/7873)] 将Jacoco插件版本从0.8.7升级到0.8.14以适配JDK25
- [[#7885](https://github.com/apache/incubator-seata/pull/7885)] 替换 fury 至 fory
- [[#7884](https://github.com/apache/incubator-seata/pull/7884)] 将 tomcat-embed-core 版本升级到 11.0.10
- [[#7888](https://github.com/apache/incubator-seata/pull/7888)] 升级namingserver模块org.apache.tomcat.embed:tomcat-embed-core
- [[#7889](https://github.com/apache/incubator-seata/pull/7889)] 升级console模块org.apache.tomcat.embed:tomcat-embed-core
- [[#7894](https://github.com/apache/incubator-seata/pull/7894)] 优化saga模块中的方法名和类名
- [[#7905](https://github.com/apache/incubator-seata/pull/7905)] 优化README文档
- [[#7909](https://github.com/apache/incubator-seata/pull/7909)] 在控制台配置文件中为namingserver地址配置添加注释
- [[#7913](https://github.com/apache/incubator-seata/pull/7913)] 移除 @author 信息
- [[#7931](https://github.com/apache/incubator-seata/pull/7931)] 固定namingserver和console的spring版本
- [[#7942](https://github.com/apache/incubator-seata/pull/7942)] 升级jib-maven-plugin版本和提高ci并行度
- [[#7935](https://github.com/apache/incubator-seata/pull/7935)] 添加 OkHttp 和 MockWebServer 依赖来解决版本冲突


### security:

- [[#7632](https://github.com/apache/incubator-seata/pull/7632)] 升级sha.js为2.4.12
- [[#7633](https://github.com/apache/incubator-seata/pull/7633)] 升级cipher-base为1.0.6
- [[#7716](https://github.com/apache/incubator-seata/pull/7716)] 升级 commons-lang 为 3.18.0
- [[#7699](https://github.com/apache/incubator-seata/pull/7699)] 升级axios到1.12.2
- [[#7845](https://github.com/apache/incubator-seata/pull/7845)] 升级node-forge到1.3.2以上
- [[#7849](https://github.com/apache/incubator-seata/pull/7849)] 升级min-document到2.19.1以上
- [[#7847](https://github.com/apache/incubator-seata/pull/7847)] 升级js-yaml到3.14.2, 4.1.1以上

### test:

- [[#7635](https://github.com/apache/incubator-seata/pull/7635)] 修正 JUnit 5 测试方法的访问修饰符及注解使用规范
- [[#7541](https://github.com/seata/seata/pull/7541)] 修复 jakarta 依赖在 jdk17+ 单测失败问题
- [[#7540](https://github.com/seata/seata/pull/7540)] 修复mock server端口冲突问题
- [[#7578](https://github.com/seata/seata/pull/7578)]  zstd解压由jni改为ZstdInputStream
- [[#7580](https://github.com/seata/seata/pull/7580)]  修复测试用例顺序错乱导致的异常
- [[#7584](https://github.com/seata/seata/pull/7584)] 修复 ConsulConfigurationTest#testInitSeataConfig 在 CI 中由于等待/重试时间过短导致的不稳定问题
- [[#7610](https://github.com/apache/incubator-seata/pull/7610)] 当nacosCaseEnabled为true时启用nacos集成测试
- [[#7672](https://github.com/apache/incubator-seata/pull/7672)] 增加 `seata-common` 模块的测试用例
- [[#7679](https://github.com/apache/incubator-seata/pull/7679)] 修复旧版本协议测试超时问题
- [[#7638](https://github.com/apache/incubator-seata/pull/7638)] 增加了 `seata-common` 模块的测试用例,删去了一个todo
- [[#7709](https://github.com/apache/incubator-seata/pull/7709)] 为dm模块增加单测
- [[#7725](https://github.com/apache/incubator-seata/pull/7725)] 为compressor模块增加单测
- [[#7718](https://github.com/apache/incubator-seata/pull/7718)] 为config模块增加单测
- [[#7723](https://github.com/apache/incubator-seata/pull/7723)] 添加 fastjson2 的 UT 来测试 PostgreSQL 数组类型
- [[#7731](https://github.com/apache/incubator-seata/pull/7731)] 为rm.fence模块添加单测
- [[#7737](https://github.com/apache/incubator-seata/pull/7737)] 为 DefaultResourceManager 和 ClusterWatcherManager 添加测试方法
- [[#7757](https://github.com/apache/incubator-seata/pull/7757)] 为 undo 模块添加单测
- [[#7763](https://github.com/apache/incubator-seata/pull/7763)] 为 RegistryNamingServerProperties 和 RegistryMetadataProperties 添加单测
- [[#7764](https://github.com/apache/incubator-seata/pull/7764)] 为 server/coordinator 模块添加单测
- [[#7777](https://github.com/apache/incubator-seata/pull/7777)] 为 seata-saga-statelang 模块添加单测
- [[#7776](https://github.com/apache/incubator-seata/pull/7776)] 为 XA 模块添加单测
- [[#7788](https://github.com/apache/incubator-seata/pull/7788)] 为 rm-datasource 模块添加单测
- [[#7774](https://github.com/apache/incubator-seata/pull/7774)] 为 server/console 模块添加单测
- [[#7767](https://github.com/apache/incubator-seata/pull/7767)] 为 server/cluster 模块添加单测
- [[#7750](https://github.com/apache/incubator-seata/pull/7750)] 为 server 模块添加单测
- [[#7733](https://github.com/apache/incubator-seata/pull/7733)] 为 core 模块添加单测
- [[#7728](https://github.com/apache/incubator-seata/pull/7728)] 为 compatible 模块添加单测
- [[#7727](https://github.com/apache/incubator-seata/pull/7727)] 为 compatible 模块添加单测
- [[#7803](https://github.com/apache/incubator-seata/pull/7803)] 修复 `DataCompareUtilsTest` 中因键迭代顺序不稳定导致的测试用例间歇性失败问题。
- [[#7804](https://github.com/apache/incubator-seata/pull/7804)] 修复 testXARollbackWithResourceLock() 以确保 CI 正常运行
- [[#7779](https://github.com/apache/incubator-seata/pull/7779)] 提高 RaftRegistryServiceImpl 单测覆盖
- [[#7801](https://github.com/apache/incubator-seata/pull/7801)] 修复 `JsonParserWrapTest.testToJSONString` 因字段顺序不稳定导致的测试用例间歇性失败问题
- [[#7800](https://github.com/apache/incubator-seata/pull/7800)] 修复 `StringUtilsTest.testToStringAndCycleDependency` 因反射字段顺序不稳定导致的测试用例间歇性失败问题
- [[#7802](https://github.com/apache/incubator-seata/pull/7802)] 修复 `ConnectionContextProxyTest` 中锁键顺序不稳定导致的测试用例间歇性失败问题。
- [[#7808](https://github.com/apache/incubator-seata/pull/7808)] 修复多个 Insert Executor 单测中因主键值比较顺序导致的间歇性失败问题
- [[#7815](https://github.com/apache/incubator-seata/pull/7815)] 通过合并测试来修复，避免因执行顺序导致的失败
- [[#7819](https://github.com/apache/incubator-seata/pull/7819)] 修复RpcStatus单测失败问题
- [[#7827](https://github.com/apache/incubator-seata/pull/7827)] 修复 TableMetaTest 中因主键名称列表顺序不稳定导致的单测间歇性失败问题
- [[#7859](https://github.com/apache/incubator-seata/pull/7859)] 修复 `MetadataTest` 因共享状态与依赖 `toString()` 输出不稳定导致的测试用例间歇性失败问题
- [[#7858](https://github.com/apache/incubator-seata/pull/7858)] 修复 `HttpTest.convertParamOfJsonStringTest` 因 Map 遍历顺序不确定导致的测试用例间歇性失败问题
- [[#7874](https://github.com/apache/incubator-seata/pull/7874)] DBType和RedisKeyConstants增加单元测试
- [[#7900](https://github.com/apache/incubator-seata/pull/7900)] ConnectionContext增加单元测试
- [[#7901](https://github.com/apache/incubator-seata/pull/7901)] LockStatus, MessageType, ProtocolConstants增加单元测试
- [[#7906](https://github.com/apache/incubator-seata/pull/7906)] Fury/Fory 增加单元测试
- [[#7907](https://github.com/apache/incubator-seata/pull/7907)] test: 修复ZkConfigurationTest的时序问题导致的ci错误
- [[#7912](https://github.com/apache/incubator-seata/pull/7912)] test: 添加 Antlr 测试以提高测试覆盖率
- [[#7933](https://github.com/apache/incubator-seata/pull/7933)] oscar数据库测试用例仅运行在druid大于等于1.2.5版本


### refactor:

- [[#7615](https://github.com/seata/seata/pull/7615)] 重构 DataSourceProxy
- [[#7617](https://github.com/seata/seata/pull/7617)] 重构 Alibaba Dubbo 和 HSF 模块
- [[#7719](https://github.com/apache/incubator-seata/pull/7719)] 替换 AbstractNettyRemotingClient 中的 synchronized 为 ReentrantLock，以支持虚拟线程
- [[#7688](https://github.com/seata/seata/pull/7688)] 增加 extensions 模块
- [[#7789](https://github.com/apache/incubator-seata/pull/7789)] 将 `GROUP_UPDATE_TIME` 重命名为 `GROUP_UPDATE_TERM`，更准确地反映其实际用途
- [[#7698](https://github.com/apache/incubator-seata/pull/7698)] 重构 test 模块
- [[#7818](https://github.com/apache/incubator-seata/pull/7818)] 增加HTTP过滤器链
- [[#7904](https://github.com/apache/incubator-seata/pull/7904)] 统一http客户端工具类为okhttp3


### doc:

- [[#7462](https://github.com/seata/seata/pull/7462)] 完善 TM 模块的 Javadoc，补充全面的英文文档说明。
- [[#7531](https://github.com/seata/seata/pull/7531)] 优化 Readme 和 change 文档
- [[#7571](https://github.com/seata/seata/pull/7571)] 在拉取请求模板中添加 CONTRIBUTING.md 超链接
- [[#7605](https://github.com/apache/incubator-seata/pull/7605)] 在application.yml中增加了seata作为注册中心的注释
- [[#7625](https://github.com/apache/incubator-seata/pull/7625)] 改进 @EnableAutoDataSourceProxy 和 DefaultFailureHandlerImpl 的 Javadoc
- [[#7702](https://github.com/apache/incubator-seata/pull/7702)] 修复 JavaDoc 中的语法错误 将 "whether use" 改为 "whether to use"

非常感谢以下 contributors 的代码贡献。若有无意遗漏，请报告。

<!-- 请确保您的 GitHub ID 在以下列表中 -->

- [slievrly](https://github.com/slievrly)
- [YvCeung](https://github.com/YvCeung)
- [xjlgod](https://github.com/xjlgod)
- [YongGoose](https://github.com/YongGoose)
- [KoKimSS](https://github.com/KoKimSS)
- [maple525866](https://github.com/maple525866)
- [funky-eyes](https://github.com/funky-eyes)
- [keepConcentration](https://github.com/keepConcentration)
- [sunheyi6](https://github.com/sunheyi6)
- [WangzJi](https://github.com/WangzJi)
- [unifolio0](https://github.com/unifolio0)
- [Asuka-star](https://github.com/Asuka-star)
- [contrueCT](https://github.com/contrueCT)
- [YoWuwuuuw](https://github.com/YoWuwuuuw)
- [yougecn](https://github.com/yougecn)
- [jongmin-chung](https://github.com/jongmin-chung)
- [jihun4452](https://github.com/jihun4452)
- [psxjoy](https://github.com/psxjoy)
- [dsomehan](https://github.com/dsomehan)
- [LegendPei](https://github.com/LegendPei)
- [lokidundun](https://github.com/lokidundun)
- [xiaoxiangyeyu0](https://github.com/xiaoxiangyeyu0)
- [jsbxyyx](https://github.com/jsbxyyx)
- [xingfudeshi](https://github.com/xingfudeshi)
- [diguage](https://github.com/diguage)
- [aias00](https://github.com/aias00)
- [MaoMaoandSnail](https://github.com/MaoMaoandSnail)
- [neronsoda](https://github.com/neronsoda)


同时，我们收到了社区反馈的很多有价值的issue和建议，非常感谢大家。
