//---------------------------------------------------------------------------
//	Greenplum Database
//	Copyright (C) 2014 VMware, Inc. or its affiliates.
//
//	@filename:
//		CParseHandlerScalarSubPlanTestExpr.cpp
//
//	@doc:
//		Implementation of the SAX parse handler class for parsing subplan test expression
//---------------------------------------------------------------------------


#include "naucrates/dxl/parser/CParseHandlerScalarSubPlanTestExpr.h"

#include "naucrates/dxl/operators/CDXLOperatorFactory.h"
#include "naucrates/dxl/parser/CParseHandlerFactory.h"
#include "naucrates/dxl/parser/CParseHandlerScalarOp.h"
using namespace gpdxl;


XERCES_CPP_NAMESPACE_USE

//---------------------------------------------------------------------------
//	@function:
//		CParseHandlerScalarSubPlanTestExpr::CParseHandlerScalarSubPlanTestExpr
//
//	@doc:
//		Ctor
//
//---------------------------------------------------------------------------
CParseHandlerScalarSubPlanTestExpr::CParseHandlerScalarSubPlanTestExpr(
	CMemoryPool *mp, CParseHandlerManager *parse_handler_mgr,
	CParseHandlerBase *parse_handler_root)
	: CParseHandlerScalarOp(mp, parse_handler_mgr, parse_handler_root),
	  m_dxl_test_expr(nullptr)
{
}

//---------------------------------------------------------------------------
//	@function:
//		CParseHandlerScalarSubPlanTestExpr::~CParseHandlerScalarSubPlanTestExpr
//
//	@doc:
//		Dtor
//
//---------------------------------------------------------------------------
CParseHandlerScalarSubPlanTestExpr::~CParseHandlerScalarSubPlanTestExpr()
{
	CRefCount::SafeRelease(m_dxl_test_expr);
}

//---------------------------------------------------------------------------
//	@function:
//		CParseHandlerScalarSubPlanTestExpr::StartElement
//
//	@doc:
//		Processes a Xerces start element event
//
//---------------------------------------------------------------------------
void
CParseHandlerScalarSubPlanTestExpr::StartElement(
	const XMLCh *const element_uri, const XMLCh *const element_local_name,
	const XMLCh *const element_qname, const Attributes &attrs)
{
	if (0 != XMLString::compareString(
				 CDXLTokens::XmlstrToken(EdxltokenScalarSubPlanTestExpr),
				 element_local_name))
	{
		// install a scalar element parser for parsing the test expression
		CParseHandlerBase *child_parse_handler =
			CParseHandlerFactory::GetParseHandler(
				m_mp, CDXLTokens::XmlstrToken(EdxltokenScalar),
				m_parse_handler_mgr, this);

		m_parse_handler_mgr->ActivateParseHandler(child_parse_handler);

		// store parse handler
		this->Append(child_parse_handler);

		child_parse_handler->startElement(element_uri, element_local_name,
										  element_qname, attrs);
	}
}

//---------------------------------------------------------------------------
//	@function:
//		CParseHandlerScalarSubPlanTestExpr::EndElement
//
//	@doc:
//		Processes a Xerces end element event
//
//---------------------------------------------------------------------------
void
CParseHandlerScalarSubPlanTestExpr::EndElement(
	const XMLCh *const,	 // element_uri,
	const XMLCh *const element_local_name,
	const XMLCh *const	// element_qname
)
{
	if (0 != XMLString::compareString(
				 CDXLTokens::XmlstrToken(EdxltokenScalarSubPlanTestExpr),
				 element_local_name) &&
		nullptr != m_dxl_test_expr)
	{
		CWStringDynamic *str = CDXLUtils::CreateDynamicStringFromXMLChArray(
			m_parse_handler_mgr->GetDXLMemoryManager(), element_local_name);
		GPOS_RAISE(gpdxl::ExmaDXL, gpdxl::ExmiDXLUnexpectedTag,
				   str->GetBuffer());
	}

	if (0 < this->Length())
	{
		CParseHandlerScalarOp *child_parse_handler =
			dynamic_cast<CParseHandlerScalarOp *>((*this)[0]);
		if (nullptr != child_parse_handler->CreateDXLNode())
		{
			m_dxl_test_expr = child_parse_handler->CreateDXLNode();
			m_dxl_test_expr->AddRef();
		}
	}

	// deactivate handler
	m_parse_handler_mgr->DeactivateHandler();
}

// EOF
