/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.gridify;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.gridify.GridifyArgument;

public class GridifyJobAdapter
extends ComputeJobAdapter {
    private static final long serialVersionUID = 0L;

    public GridifyJobAdapter(GridifyArgument arg) {
        super((Object)arg);
    }

    @Override
    public Object execute() {
        GridifyArgument arg = (GridifyArgument)this.argument(0);
        try {
            Method mtd = arg.getMethodClass().getDeclaredMethod(arg.getMethodName(), arg.getMethodParameterTypes());
            if (!mtd.isAccessible()) {
                try {
                    mtd.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IgniteException("Got security exception when attempting to soften access control for @Gridify method: " + mtd, e);
                }
            }
            Object obj = null;
            if (!Modifier.isStatic(mtd.getModifiers())) {
                obj = arg.getTarget();
            }
            return mtd.invoke(obj, arg.getMethodParameters());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IgniteException) {
                throw (IgniteException)e.getTargetException();
            }
            throw new IgniteException("Failed to invoke a method due to user exception.", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IgniteException("Failed to access method for execution.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IgniteException("Failed to find method for execution.", e);
        }
    }
}

