/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.internal.util.GridConcurrentSkipListSet;

public class GridBoundedConcurrentOrderedSet<E>
extends GridConcurrentSkipListSet<E> {
    private static final long serialVersionUID = 0L;
    private final AtomicInteger cnt = new AtomicInteger(0);
    private int max;

    public GridBoundedConcurrentOrderedSet(int max) {
        assert (max > 0);
        this.max = max;
    }

    public GridBoundedConcurrentOrderedSet(int max, Comparator<? super E> comp) {
        super(comp);
        assert (max > 0);
        this.max = max;
    }

    public GridBoundedConcurrentOrderedSet(int max, Collection<? extends E> c) {
        super(c);
        assert (max > 0);
        this.max = max;
    }

    public GridBoundedConcurrentOrderedSet(int max, SortedSet<E> s) {
        super(s);
        assert (max > 0);
        this.max = max;
    }

    @Override
    public boolean add(E e) {
        GridArgumentCheck.notNull(e, "e");
        if (super.add(e)) {
            int c;
            this.cnt.incrementAndGet();
            while ((c = this.cnt.get()) > this.max) {
                if (!this.cnt.compareAndSet(c, c - 1)) continue;
                try {
                    while (!super.remove(this.first())) {
                    }
                }
                catch (NoSuchElementException e1) {
                    e1.printStackTrace();
                    assert (false) : "Internal error in grid bounded ordered set.";
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int size = this.cnt.get();
        return size < 0 ? 0 : size;
    }

    @Override
    public GridBoundedConcurrentOrderedSet<E> clone() {
        GridBoundedConcurrentOrderedSet s = (GridBoundedConcurrentOrderedSet)super.clone();
        s.max = this.max;
        return s;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.cnt.decrementAndGet();
            return true;
        }
        return false;
    }
}

