/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorageListener;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ReadableDistributedMetaStorage {
    public static boolean isSupported(GridKernalContext ctx) {
        DiscoverySpi discoSpi = ctx.config().getDiscoverySpi();
        if (discoSpi instanceof IgniteDiscoverySpi) {
            return ((IgniteDiscoverySpi)discoSpi).allNodesSupport(IgniteFeatures.DISTRIBUTED_METASTORAGE);
        }
        Collection<ClusterNode> nodes = discoSpi.getRemoteNodes();
        return IgniteFeatures.allNodesSupports(nodes, IgniteFeatures.DISTRIBUTED_METASTORAGE);
    }

    public long getUpdatesCount();

    @Nullable
    public <T extends Serializable> T read(@NotNull String var1) throws IgniteCheckedException;

    public void iterate(@NotNull String var1, @NotNull BiConsumer<String, ? super Serializable> var2) throws IgniteCheckedException;

    public void listen(@NotNull Predicate<String> var1, DistributedMetaStorageListener<?> var2);
}

