/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.compute.task;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.network.ClusterNode;

public class MapReduceJob<T, R> {
    private final Set<ClusterNode> nodes;
    private final JobDescriptor<T, R> jobDescriptor;
    private final T args;

    private MapReduceJob(Set<ClusterNode> nodes, JobDescriptor<T, R> jobDescriptor, T args) {
        this.nodes = Collections.unmodifiableSet(nodes);
        this.jobDescriptor = jobDescriptor;
        this.args = args;
    }

    public Set<ClusterNode> nodes() {
        return this.nodes;
    }

    public JobDescriptor<T, R> jobDescriptor() {
        return this.jobDescriptor;
    }

    public T arg() {
        return this.args;
    }

    public ComputeJobRunnerBuilder<T, R> toBuilder() {
        return MapReduceJob.builder().jobDescriptor(this.jobDescriptor).nodes(this.nodes).args(this.args);
    }

    public static <T, R> ComputeJobRunnerBuilder<T, R> builder() {
        return new ComputeJobRunnerBuilder();
    }

    public static class ComputeJobRunnerBuilder<T, R> {
        private final Set<ClusterNode> nodes = new HashSet<ClusterNode>();
        private JobDescriptor<T, R> jobDescriptor;
        private T args;

        public ComputeJobRunnerBuilder<T, R> nodes(Collection<ClusterNode> nodes) {
            this.nodes.addAll(nodes);
            return this;
        }

        public ComputeJobRunnerBuilder<T, R> node(ClusterNode node) {
            this.nodes.add(node);
            return this;
        }

        public ComputeJobRunnerBuilder<T, R> jobDescriptor(JobDescriptor<T, R> jobDescriptor) {
            this.jobDescriptor = jobDescriptor;
            return this;
        }

        public ComputeJobRunnerBuilder<T, R> args(T args) {
            this.args = args;
            return this;
        }

        public MapReduceJob<T, R> build() {
            if (this.nodes.isEmpty()) {
                throw new IllegalArgumentException();
            }
            return new MapReduceJob<T, R>(this.nodes, this.jobDescriptor, this.args);
        }
    }
}

