/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.tx;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteTuple3;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.tx.TransactionException;

public class ClientTransactionCommitRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, ClientResourceRegistry resources, ClientHandlerMetricSource metrics, ClockService clockService, IgniteTablesInternal igniteTables, boolean enableDirectMapping, HybridTimestampTracker tsTracker) throws IgniteInternalCheckedException {
        long resourceId = in.unpackLong();
        InternalTransaction tx = resources.remove(resourceId).get(InternalTransaction.class);
        if (enableDirectMapping && !tx.isReadOnly()) {
            TableViewInternal table;
            int cnt = in.unpackInt();
            ArrayList<IgniteTuple3> list = new ArrayList<IgniteTuple3>();
            for (int i = 0; i < cnt; ++i) {
                int tableId = in.unpackInt();
                int partId = in.unpackInt();
                String consistentId = in.unpackString();
                long token = in.unpackLong();
                list.add(new IgniteTuple3((Object)new TablePartitionId(tableId, partId), (Object)consistentId, (Object)token));
            }
            if (cnt > 0) {
                long causality = in.unpackLong();
                clockService.updateClock(HybridTimestamp.hybridTimestamp((long)causality));
            }
            TransactionException ex = null;
            for (IgniteTuple3 enlistment : list) {
                table = igniteTables.cachedTable(((TablePartitionId)enlistment.get1()).tableId());
                if (table == null) {
                    ex = new TransactionException(ErrorGroups.Transactions.TX_COMMIT_ERR, "Table not found [id=" + ((TablePartitionId)enlistment.get1()).tableId() + "]");
                    break;
                }
                if (ClientTransactionCommitRequest.merge(table.internalTable(), ((TablePartitionId)enlistment.get1()).partitionId(), (String)enlistment.get2(), (Long)enlistment.get3(), tx, true)) continue;
                ex = new TransactionException(ErrorGroups.Transactions.TX_COMMIT_ERR, "Invalid enlistment token [id=" + ((TablePartitionId)enlistment.get1()).tableId() + "]");
                break;
            }
            if (ex != null) {
                for (IgniteTuple3 enlistment : list) {
                    table = igniteTables.cachedTable(((TablePartitionId)enlistment.get1()).tableId());
                    if (table == null) continue;
                    ClientTransactionCommitRequest.merge(table.internalTable(), ((TablePartitionId)enlistment.get1()).partitionId(), (String)enlistment.get2(), (Long)enlistment.get3(), tx, false);
                }
                TransactionException finalEx = ex;
                return tx.rollbackAsync().handle((res, err) -> {
                    if (err != null) {
                        finalEx.addSuppressed((Throwable)err);
                    }
                    metrics.transactionsActiveDecrement();
                    ExceptionUtils.sneakyThrow((Throwable)finalEx);
                    return null;
                });
            }
        }
        return tx.commitAsync().handle((res, err) -> {
            if (!tx.isReadOnly()) {
                tsTracker.update(clockService.current());
            }
            metrics.transactionsActiveDecrement();
            if (err != null) {
                throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)err);
            }
            return null;
        });
    }

    public static boolean merge(InternalTable table, int partId, String consistentId, long token, InternalTransaction tx, boolean commit) {
        ReplicationGroupId replicationGroupId = table.targetReplicationGroupId(partId);
        PendingTxPartitionEnlistment existing = tx.enlistedPartition(replicationGroupId);
        if (existing != null) {
            return !commit || existing.consistencyToken() == token;
        }
        tx.enlist(replicationGroupId, table.tableId(), consistentId, token);
        return true;
    }
}

