/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.common.export;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.common.export.AutoValue_RetryPolicy;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@AutoValue
public abstract class RetryPolicy {
    private static final int DEFAULT_MAX_ATTEMPTS = 5;
    private static final int DEFAULT_INITIAL_BACKOFF_SECONDS = 1;
    private static final int DEFAULT_MAX_BACKOFF_SECONDS = 5;
    private static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;
    private static final RetryPolicy DEFAULT = RetryPolicy.builder().build();

    RetryPolicy() {
    }

    public static RetryPolicy getDefault() {
        return DEFAULT;
    }

    public static RetryPolicyBuilder builder() {
        return new AutoValue_RetryPolicy.Builder().setMaxAttempts(5).setInitialBackoff(Duration.ofSeconds(1L)).setMaxBackoff(Duration.ofSeconds(5L)).setBackoffMultiplier(1.5);
    }

    public abstract RetryPolicyBuilder toBuilder();

    public abstract int getMaxAttempts();

    public abstract Duration getInitialBackoff();

    public abstract Duration getMaxBackoff();

    public abstract double getBackoffMultiplier();

    @Nullable
    public abstract Predicate<IOException> getRetryExceptionPredicate();

    @AutoValue.Builder
    public static abstract class RetryPolicyBuilder {
        RetryPolicyBuilder() {
        }

        public abstract RetryPolicyBuilder setMaxAttempts(int var1);

        public abstract RetryPolicyBuilder setInitialBackoff(Duration var1);

        public abstract RetryPolicyBuilder setMaxBackoff(Duration var1);

        public abstract RetryPolicyBuilder setBackoffMultiplier(double var1);

        public abstract RetryPolicyBuilder setRetryExceptionPredicate(Predicate<IOException> var1);

        abstract RetryPolicy autoBuild();

        public RetryPolicy build() {
            RetryPolicy retryPolicy = this.autoBuild();
            Utils.checkArgument((retryPolicy.getMaxAttempts() > 1 && retryPolicy.getMaxAttempts() < 6 ? 1 : 0) != 0, (String)"maxAttempts must be greater than 1 and less than 6");
            Utils.checkArgument((retryPolicy.getInitialBackoff().toNanos() > 0L ? 1 : 0) != 0, (String)"initialBackoff must be greater than 0");
            Utils.checkArgument((retryPolicy.getMaxBackoff().toNanos() > 0L ? 1 : 0) != 0, (String)"maxBackoff must be greater than 0");
            Utils.checkArgument((retryPolicy.getBackoffMultiplier() > 0.0 ? 1 : 0) != 0, (String)"backoffMultiplier must be greater than 0");
            return retryPolicy;
        }
    }
}

