/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnContainer;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class CatalogTableDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry,
CatalogColumnContainer {
    public static final int INITIAL_TABLE_VERSION = 1;
    private final int zoneId;
    private final int schemaId;
    private final int pkIndexId;
    @IgniteToStringExclude
    private final CatalogTableSchemaVersions schemaVersions;
    @IgniteToStringInclude
    private final List<CatalogTableColumnDescriptor> columns;
    @IgniteToStringInclude
    private final List<String> primaryKeyColumns;
    @IgniteToStringInclude
    private final List<String> colocationColumns;
    @IgniteToStringExclude
    private final Map<String, Int2ObjectMap.Entry<CatalogTableColumnDescriptor>> columnsMap;
    private final String storageProfile;

    private CatalogTableDescriptor(int id, int schemaId, int pkIndexId, String name, int zoneId, List<CatalogTableColumnDescriptor> columns, List<String> pkCols, @Nullable List<String> colocationCols, CatalogTableSchemaVersions schemaVersions, String storageProfile, HybridTimestamp timestamp) {
        super(id, CatalogObjectDescriptor.Type.TABLE, name, timestamp);
        this.schemaId = schemaId;
        this.pkIndexId = pkIndexId;
        this.zoneId = zoneId;
        this.columns = columns;
        this.primaryKeyColumns = pkCols;
        HashMap columnMap = IgniteUtils.newHashMap((int)columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            CatalogTableColumnDescriptor column = columns.get(i);
            columnMap.put(column.name(), new AbstractInt2ObjectMap.BasicEntry(i, (Object)column));
        }
        this.columnsMap = columnMap;
        this.colocationColumns = Objects.requireNonNullElse(colocationCols, pkCols);
        this.schemaVersions = Objects.requireNonNull(schemaVersions, "No catalog schema versions.");
        this.storageProfile = Objects.requireNonNull(storageProfile, "No storage profile.");
    }

    public Builder copyBuilder() {
        return new Builder().id(this.id()).name(this.name()).timestamp(this.updateTimestamp()).zoneId(this.zoneId()).schemaId(this.schemaId()).primaryKeyIndexId(this.primaryKeyIndexId()).schemaVersions(this.schemaVersions).columns(this.columns).primaryKeyColumns(this.primaryKeyColumns()).colocationColumns(this.colocationColumns()).storageProfile(this.storageProfile());
    }

    public static Builder builder() {
        return new Builder();
    }

    public int schemaId() {
        return this.schemaId;
    }

    public CatalogTableSchemaVersions schemaVersions() {
        return this.schemaVersions;
    }

    public int zoneId() {
        return this.zoneId;
    }

    public int primaryKeyIndexId() {
        return this.pkIndexId;
    }

    public int latestSchemaVersion() {
        return this.schemaVersions.latestVersion();
    }

    public List<String> primaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<String> colocationColumns() {
        return this.colocationColumns;
    }

    @Override
    public List<CatalogTableColumnDescriptor> columns() {
        return this.columns;
    }

    @Nullable
    public CatalogTableColumnDescriptor column(String name) {
        Int2ObjectMap.Entry<CatalogTableColumnDescriptor> column = this.columnsMap.get(name);
        if (column != null) {
            return (CatalogTableColumnDescriptor)column.getValue();
        }
        return null;
    }

    public int columnIndex(String name) {
        Int2ObjectMap.Entry<CatalogTableColumnDescriptor> column = this.columnsMap.get(name);
        if (column != null) {
            return column.getIntKey();
        }
        return -1;
    }

    public boolean isPrimaryKeyColumn(String name) {
        return this.primaryKeyColumns.contains(name);
    }

    public boolean isColocationColumn(String name) {
        return this.colocationColumns.contains(name);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_TABLE.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogTableDescriptor.class, (Object)this, (String)super.toString());
    }

    public String storageProfile() {
        return this.storageProfile;
    }

    public static final class Builder {
        private int id;
        private String name;
        private int zoneId;
        private int schemaId;
        private int pkIndexId;
        private CatalogTableSchemaVersions schemaVersions;
        private List<CatalogTableColumnDescriptor> columns;
        private List<String> primaryKeyColumns;
        @Nullable
        private List<String> colocationColumns;
        private String storageProfile;
        private HybridTimestamp timestamp = CatalogManager.INITIAL_TIMESTAMP;
        private int latestSchemaVersion = 0;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder zoneId(int zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public Builder primaryKeyIndexId(int primaryKeyIndexId) {
            this.pkIndexId = primaryKeyIndexId;
            return this;
        }

        public Builder schemaVersions(CatalogTableSchemaVersions schemaVersions) {
            this.schemaVersions = schemaVersions;
            return this;
        }

        public Builder columns(List<CatalogTableColumnDescriptor> columns) {
            this.columns = columns;
            return this;
        }

        public Builder primaryKeyColumns(List<String> primaryKeyColumns) {
            this.primaryKeyColumns = primaryKeyColumns;
            return this;
        }

        public Builder colocationColumns(@Nullable List<String> colocationColumns) {
            this.colocationColumns = colocationColumns;
            return this;
        }

        public Builder storageProfile(String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        public Builder latestSchemaVersion(int latestSchemaVersion) {
            this.latestSchemaVersion = latestSchemaVersion;
            return this;
        }

        public CatalogTableDescriptor build() {
            CatalogTableSchemaVersions.TableVersion latestTableVersion;
            Objects.requireNonNull(this.columns, "No columns defined.");
            if (this.columns.isEmpty()) {
                throw new IllegalArgumentException("No columns defined.");
            }
            Objects.requireNonNull(this.primaryKeyColumns, "No primary key columns.");
            if (this.primaryKeyColumns.isEmpty()) {
                throw new IllegalArgumentException("No primary key columns.");
            }
            if (this.schemaVersions == null) {
                this.schemaVersions = new CatalogTableSchemaVersions(new CatalogTableSchemaVersions.TableVersion(this.columns));
            }
            if (this.latestSchemaVersion == 0) {
                this.latestSchemaVersion = this.schemaVersions.latestVersion();
            } else if (this.latestSchemaVersion < this.schemaVersions.latestVersion()) {
                throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Latest schema version {} should not be less than a previous version {}.", (Object[])new Object[]{this.latestSchemaVersion, this.schemaVersions.latestVersion()}));
            }
            if (this.latestSchemaVersion == this.schemaVersions.latestVersion() && !Objects.equals((latestTableVersion = Objects.requireNonNull(this.schemaVersions.get(this.schemaVersions.latestVersion()))).columns(), this.columns)) {
                throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Latest schema version columns do not match descriptor definition columns. Schema columns: {}, table columns: {}.", (Object[])new Object[]{latestTableVersion.columns(), this.columns}));
            }
            CatalogTableSchemaVersions newSchemaVersions = this.latestSchemaVersion == this.schemaVersions.latestVersion() ? this.schemaVersions : this.schemaVersions.append(new CatalogTableSchemaVersions.TableVersion(this.columns), this.latestSchemaVersion);
            return new CatalogTableDescriptor(this.id, this.schemaId, this.pkIndexId, this.name, this.zoneId, this.columns, this.primaryKeyColumns, this.colocationColumns, newSchemaVersions, this.storageProfile, this.timestamp);
        }
    }
}

