/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum SqlQueryType {
    QUERY,
    DML,
    DDL,
    EXPLAIN,
    TX_CONTROL,
    KILL;

    public static final Set<SqlQueryType> SINGLE_STMT_TYPES;
    public static final Set<SqlQueryType> ALL;

    public boolean supportsParseResultCaching() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsExplain() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsIndependentExecution() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsTransactions() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsExplicitTransactions() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 3: 
            case 5: {
                return true;
            }
            case 2: 
            case 4: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean implicitTransactionReadOnlyMode() {
        switch (this.ordinal()) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: 
            case 4: 
            case 5: {
                throw new UnsupportedOperationException(String.valueOf((Object)this) + " does not support requesting transaction mode.");
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean hasRowSet() {
        switch (this.ordinal()) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean returnsAffectedRows() {
        switch (this.ordinal()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public boolean supportsWasApplied() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return false;
            }
            case 2: 
            case 5: {
                return true;
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    public String displayName() {
        switch (this.ordinal()) {
            case 0: {
                return "Query";
            }
            case 1: {
                return "DML";
            }
            case 2: {
                return "DDL";
            }
            case 3: {
                return "Explain";
            }
            case 4: {
                return "Transaction control statement";
            }
            case 5: {
                return "Kill";
            }
        }
        throw SqlQueryType.unexpectedSqlQueryType(this);
    }

    private static IllegalStateException unexpectedSqlQueryType(SqlQueryType type) {
        return new IllegalStateException("Unexpected query type:" + String.valueOf((Object)type));
    }

    static {
        SINGLE_STMT_TYPES = EnumSet.copyOf(Arrays.stream(SqlQueryType.values()).filter(SqlQueryType::supportsIndependentExecution).collect(Collectors.toList()));
        ALL = EnumSet.allOf(SqlQueryType.class);
    }
}

