/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.storage.configurations.StorageProfileView;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbProfileConfiguration;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbProfileView;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.WriteBufferManager;

public class RocksDbStorageProfile {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbStorageProfile.class);
    private final RocksDbProfileConfiguration storageProfileConfig;
    private Cache cache;
    private WriteBufferManager writeBufferManager;

    public RocksDbStorageProfile(RocksDbProfileConfiguration storageProfileConfig) {
        this.storageProfileConfig = storageProfileConfig;
    }

    public void start() {
        long writeBufferSize = (Long)this.storageProfileConfig.writeBufferSizeBytes().value();
        long totalCacheSize = this.sizeBytes() + writeBufferSize;
        this.cache = new LRUCache(totalCacheSize, -1, false);
        this.writeBufferManager = new WriteBufferManager(writeBufferSize, this.cache);
    }

    private long sizeBytes() {
        RocksDbProfileView storageProfileConfigView = (RocksDbProfileView)this.storageProfileConfig.value();
        long dataRegionSize = storageProfileConfigView.sizeBytes();
        if (dataRegionSize == -1L) {
            dataRegionSize = StorageEngine.defaultDataRegionSize();
            LOG.info("{}.{} property is not specified, setting its value to {}", new Object[]{storageProfileConfigView.name(), this.storageProfileConfig.writeBufferSizeBytes().key(), dataRegionSize});
        }
        return dataRegionSize;
    }

    public String name() {
        return ((StorageProfileView)this.storageProfileConfig.value()).name();
    }

    public void stop() throws Exception {
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writeBufferManager, this.cache});
    }

    public WriteBufferManager writeBufferManager() {
        return this.writeBufferManager;
    }
}

