/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.reactor.http.client.BridgedReactorHttpClient;
import io.micronaut.reactor.http.client.ReactorStreamingHttpClient;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
class BridgedReactorStreamingHttpClient
extends BridgedReactorHttpClient
implements ReactorStreamingHttpClient {
    private final StreamingHttpClient streamingHttpClient;

    BridgedReactorStreamingHttpClient(StreamingHttpClient streamingHttpClient) {
        super((HttpClient)streamingHttpClient);
        this.streamingHttpClient = streamingHttpClient;
    }

    @Override
    public <I> Flux<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request) {
        return Flux.from((Publisher)this.streamingHttpClient.dataStream(request));
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        return Flux.from((Publisher)this.streamingHttpClient.dataStream(request, errorType));
    }

    @Override
    public <I> Flux<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request) {
        return Flux.from((Publisher)this.streamingHttpClient.exchangeStream(request));
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        return Flux.from((Publisher)this.streamingHttpClient.exchangeStream(request, errorType));
    }

    @Override
    public <I> Flux<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> request) {
        return Flux.from((Publisher)this.streamingHttpClient.jsonStream(request));
    }

    @Override
    public <I, O> Flux<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type) {
        return Flux.from((Publisher)this.streamingHttpClient.jsonStream(request, type));
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type, @NonNull Argument<?> errorType) {
        return Flux.from((Publisher)this.streamingHttpClient.jsonStream(request, type, errorType));
    }

    @Override
    public <I, O> Flux<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        return Flux.from((Publisher)this.streamingHttpClient.jsonStream(request, type));
    }
}

