/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.rpc.AppendEntriesRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class AppendEntriesRequestDeserializer
implements MessageDeserializer<RpcRequests.AppendEntriesRequest> {
    private final AppendEntriesRequestBuilder msg;

    AppendEntriesRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.appendEntriesRequest();
    }

    public Class<RpcRequests.AppendEntriesRequest> klass() {
        return RpcRequests.AppendEntriesRequest.class;
    }

    public RpcRequests.AppendEntriesRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("committedIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.committedIndex(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readByteBuffer("data");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.data((ByteBuffer)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readCollection("entriesList", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.entriesList((Collection<RaftOutter.EntryMeta>)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((String)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readString("peerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.peerId((String)tmp);
                reader.incrementState();
            }
            case 5: {
                long tmp = reader.readLong("prevLogIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.prevLogIndex(tmp);
                reader.incrementState();
            }
            case 6: {
                long tmp = reader.readLong("prevLogTerm");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.prevLogTerm(tmp);
                reader.incrementState();
            }
            case 7: {
                String tmp = reader.readString("serverId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.serverId(tmp);
                reader.incrementState();
            }
            case 8: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
            case 9: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.AppendEntriesRequest.class);
    }
}

