/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler.replacement;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.HttpStatusHandler;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=HttpStatusHandler.class)
@Requires(classes={HttpStatusException.class, ExceptionHandler.class})
public class HttpStatusHandlerReplacement
implements ExceptionHandler<HttpStatusException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, HttpStatusException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.valueOf(exception.getStatus().getCode())).detail(exception.getMessage()));
    }
}

