/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.streams.BinaryAbstractStream;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.util.GridUnsafe;

public abstract class BinaryAbstractInputStream
extends BinaryAbstractStream
implements BinaryInputStream {
    protected int len;

    @Override
    public byte readByte() {
        this.ensureEnoughData(1);
        return this.readByteAndShift();
    }

    @Override
    public byte[] readByteArray(int cnt) {
        this.ensureEnoughData(cnt);
        byte[] res = new byte[cnt];
        this.copyAndShift(res, GridUnsafe.BYTE_ARR_OFF, cnt);
        return res;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    @Override
    public boolean[] readBooleanArray(int cnt) {
        this.ensureEnoughData(cnt);
        boolean[] res = new boolean[cnt];
        this.copyAndShift(res, GridUnsafe.BOOLEAN_ARR_OFF, cnt);
        return res;
    }

    @Override
    public short readShort() {
        this.ensureEnoughData(2);
        short res = this.readShortFast();
        this.shift(2);
        return res;
    }

    @Override
    public short[] readShortArray(int cnt) {
        int len = cnt << 1;
        this.ensureEnoughData(len);
        short[] res = new short[cnt];
        this.copyAndShift(res, GridUnsafe.SHORT_ARR_OFF, len);
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < res.length; ++i) {
                res[i] = Short.reverseBytes(res[i]);
            }
        }
        return res;
    }

    @Override
    public char readChar() {
        this.ensureEnoughData(2);
        char res = this.readCharFast();
        this.shift(2);
        return res;
    }

    @Override
    public char[] readCharArray(int cnt) {
        int len = cnt << 1;
        this.ensureEnoughData(len);
        char[] res = new char[cnt];
        this.copyAndShift(res, GridUnsafe.CHAR_ARR_OFF, len);
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < res.length; ++i) {
                res[i] = Character.reverseBytes(res[i]);
            }
        }
        return res;
    }

    @Override
    public int readInt() {
        this.ensureEnoughData(4);
        int res = this.readIntFast();
        this.shift(4);
        return res;
    }

    @Override
    public int[] readIntArray(int cnt) {
        int len = cnt << 2;
        this.ensureEnoughData(len);
        int[] res = new int[cnt];
        this.copyAndShift(res, GridUnsafe.INT_ARR_OFF, len);
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < res.length; ++i) {
                res[i] = Integer.reverseBytes(res[i]);
            }
        }
        return res;
    }

    @Override
    public byte readBytePositioned(int pos) {
        int delta = pos + 1 - this.pos;
        if (delta > 0) {
            this.ensureEnoughData(delta);
        }
        return this.readBytePositioned0(pos);
    }

    @Override
    public short readShortPositioned(int pos) {
        int delta = pos + 2 - this.pos;
        if (delta > 0) {
            this.ensureEnoughData(delta);
        }
        return this.readShortPositioned0(pos);
    }

    @Override
    public int readIntPositioned(int pos) {
        int delta = pos + 4 - this.pos;
        if (delta > 0) {
            this.ensureEnoughData(delta);
        }
        return this.readIntPositioned0(pos);
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public float[] readFloatArray(int cnt) {
        int len = cnt << 2;
        this.ensureEnoughData(len);
        float[] res = new float[cnt];
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < res.length; ++i) {
                int x = this.readIntFast();
                this.shift(4);
                res[i] = Float.intBitsToFloat(x);
            }
        } else {
            this.copyAndShift(res, GridUnsafe.FLOAT_ARR_OFF, len);
        }
        return res;
    }

    @Override
    public long readLong() {
        this.ensureEnoughData(8);
        long res = this.readLongFast();
        this.shift(8);
        return res;
    }

    @Override
    public long[] readLongArray(int cnt) {
        int len = cnt << 3;
        this.ensureEnoughData(len);
        long[] res = new long[cnt];
        this.copyAndShift(res, GridUnsafe.LONG_ARR_OFF, len);
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < res.length; ++i) {
                res[i] = Long.reverseBytes(res[i]);
            }
        }
        return res;
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public double[] readDoubleArray(int cnt) {
        int len = cnt << 3;
        this.ensureEnoughData(len);
        double[] res = new double[cnt];
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < res.length; ++i) {
                long x = this.readLongFast();
                this.shift(8);
                res[i] = Double.longBitsToDouble(x);
            }
        } else {
            this.copyAndShift(res, GridUnsafe.DOUBLE_ARR_OFF, len);
        }
        return res;
    }

    @Override
    public int read(byte[] arr, int off, int len) {
        if (len > this.remaining()) {
            len = this.remaining();
        }
        this.copyAndShift(arr, GridUnsafe.BYTE_ARR_OFF + (long)off, len);
        return len;
    }

    @Override
    public void position(int pos) {
        if (this.remaining() + this.pos < pos) {
            throw new BinaryObjectException("Position is out of bounds: " + pos);
        }
        this.pos = pos;
    }

    @Override
    public long offheapPointer() {
        return 0L;
    }

    @Override
    public long rawOffheapPointer() {
        return 0L;
    }

    protected void ensureEnoughData(int cnt) {
        if (this.remaining() < cnt) {
            throw new BinaryObjectException("Not enough data to read the value [position=" + this.pos + ", requiredBytes=" + cnt + ", remainingBytes=" + this.remaining() + "]");
        }
    }

    protected abstract byte readByteAndShift();

    protected abstract void copyAndShift(Object var1, long var2, int var4);

    protected abstract short readShortFast();

    protected abstract char readCharFast();

    protected abstract int readIntFast();

    protected abstract long readLongFast();

    protected abstract byte readBytePositioned0(int var1);

    protected abstract short readShortPositioned0(int var1);

    protected abstract int readIntPositioned0(int var1);
}

