/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.affinity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxyImpl;
import org.apache.ignite.internal.processors.platform.cache.affinity.PlatformAffinityFunctionTarget;
import org.apache.ignite.internal.processors.platform.cache.affinity.PlatformAffinityUtils;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.IgniteInstanceResource;

public class PlatformAffinityFunction
implements AffinityFunction,
Externalizable,
LifecycleAware {
    private static final long serialVersionUID = 0L;
    private static final byte FLAG_PARTITION = 1;
    private static final byte FLAG_REMOVE_NODE = 2;
    private static final byte FLAG_ASSIGN_PARTITIONS = 4;
    private Object userFunc;
    private int partitions;
    private AffinityFunction baseFunc;
    private byte overrideFlags;
    private transient Ignite ignite;
    private transient PlatformContext ctx;
    private transient long ptr;
    private transient PlatformAffinityFunctionTarget baseTarget;

    public PlatformAffinityFunction() {
        this.partitions = -1;
    }

    public PlatformAffinityFunction(Object func, int partitions, byte overrideFlags, AffinityFunction baseFunc) {
        this.userFunc = func;
        this.partitions = partitions;
        this.overrideFlags = overrideFlags;
        this.baseFunc = baseFunc;
    }

    public Object getUserFunc() {
        return this.userFunc;
    }

    public AffinityFunction getBaseFunc() {
        return this.baseFunc;
    }

    public byte getOverrideFlags() {
        return this.overrideFlags;
    }

    @Override
    public void reset() {
        if (this.baseFunc != null) {
            this.baseFunc.reset();
        }
    }

    @Override
    public int partitions() {
        assert (this.partitions > 0);
        return this.partitions;
    }

    @Override
    public int partition(Object key) {
        if ((this.overrideFlags & 1) == 0) {
            assert (this.baseFunc != null);
            return this.baseFunc.partition(key);
        }
        assert (this.ctx != null);
        assert (this.ptr != 0L);
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeLong(this.ptr);
            writer.writeObject(key);
            out.synchronize();
            int n = this.ctx.gateway().affinityFunctionPartition(mem.pointer());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
        if ((this.overrideFlags & 4) == 0) {
            assert (this.baseFunc != null);
            return this.baseFunc.assignPartitions(affCtx);
        }
        assert (this.ctx != null);
        assert (this.ptr != 0L);
        assert (affCtx != null);
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeLong(this.ptr);
            PlatformAffinityUtils.writeAffinityFunctionContext(affCtx, writer, this.ctx);
            out.synchronize();
            if (this.baseTarget != null) {
                this.baseTarget.setCurrentAffinityFunctionContext(affCtx);
            }
            try {
                this.ctx.gateway().affinityFunctionAssignPartitions(mem.pointer());
            }
            finally {
                if (this.baseTarget != null) {
                    this.baseTarget.setCurrentAffinityFunctionContext(null);
                }
            }
            List<List<ClusterNode>> list = PlatformAffinityUtils.readPartitionAssignment(this.ctx.reader(mem), this.ctx);
            return list;
        }
    }

    @Override
    public void removeNode(UUID nodeId) {
        if ((this.overrideFlags & 2) == 0) {
            assert (this.baseFunc != null);
            this.baseFunc.removeNode(nodeId);
            return;
        }
        assert (this.ctx != null);
        assert (this.ptr != 0L);
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeLong(this.ptr);
            writer.writeUuid(nodeId);
            out.synchronize();
            this.ctx.gateway().affinityFunctionRemoveNode(mem.pointer());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.userFunc);
        out.writeInt(this.partitions);
        out.writeByte(this.overrideFlags);
        out.writeObject(this.baseFunc);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.userFunc = in.readObject();
        this.partitions = in.readInt();
        this.overrideFlags = in.readByte();
        this.baseFunc = (AffinityFunction)in.readObject();
    }

    @Override
    public void start() throws IgniteException {
        if (this.userFunc == null) {
            return;
        }
        assert (this.ignite != null);
        this.ctx = PlatformUtils.platformContext(this.ignite);
        assert (this.ctx != null);
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObject(this.userFunc);
            out.synchronize();
            this.baseTarget = this.baseFunc != null ? new PlatformAffinityFunctionTarget(this.ctx, this.baseFunc) : null;
            PlatformTargetProxyImpl baseTargetProxy = this.baseTarget != null ? new PlatformTargetProxyImpl(this.baseTarget, this.ctx) : null;
            this.ptr = this.ctx.gateway().affinityFunctionInit(mem.pointer(), baseTargetProxy);
        }
    }

    @Override
    public void stop() throws IgniteException {
        if (this.ptr == 0L) {
            return;
        }
        assert (this.ctx != null);
        this.ctx.gateway().affinityFunctionDestroy(this.ptr);
    }

    @IgniteInstanceResource
    public void setIgnite(Ignite ignite) throws IgniteCheckedException {
        this.ignite = ignite;
        if (this.baseFunc != null && ignite != null) {
            ((IgniteEx)ignite).context().resource().injectGeneric(this.baseFunc);
        }
    }
}

