/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class FixLeftmostChildRecord
extends PageDeltaRecord {
    private long rightId;

    public FixLeftmostChildRecord(int grpId, long pageId, long rightId) {
        super(grpId, pageId);
        this.rightId = rightId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        BPlusInnerIO io = (BPlusInnerIO)PageIO.getBPlusIO(pageAddr);
        io.setLeft(pageAddr, 0, this.rightId);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_FIX_LEFTMOST_CHILD;
    }

    public long rightId() {
        return this.rightId;
    }

    @Override
    public String toString() {
        return S.toString(FixLeftmostChildRecord.class, this, "super", (Object)super.toString());
    }
}

