/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import org.apache.hc.core5.net.URIAuthority;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestURIAuthority {
    TestURIAuthority() {
    }

    @Test
    void testConstructor() {
        URIAuthority host1 = new URIAuthority("somehost");
        Assertions.assertEquals((Object)"somehost", (Object)host1.getHostName());
        Assertions.assertEquals((int)-1, (int)host1.getPort());
        URIAuthority host2 = new URIAuthority("somehost", 8080);
        Assertions.assertEquals((Object)"somehost", (Object)host2.getHostName());
        Assertions.assertEquals((int)8080, (int)host2.getPort());
        URIAuthority host3 = new URIAuthority("somehost", -1);
        Assertions.assertEquals((Object)"somehost", (Object)host3.getHostName());
        Assertions.assertEquals((int)-1, (int)host3.getPort());
    }

    @Test
    void testHashCode() {
        URIAuthority host1 = new URIAuthority("somehost", 8080);
        URIAuthority host2 = new URIAuthority("somehost", 80);
        URIAuthority host3 = new URIAuthority("someotherhost", 8080);
        URIAuthority host4 = new URIAuthority("somehost", 80);
        URIAuthority host5 = new URIAuthority("SomeHost", 80);
        URIAuthority host6 = new URIAuthority("user", "SomeHost", 80);
        URIAuthority host7 = new URIAuthority("user", "somehost", 80);
        Assertions.assertEquals((int)host1.hashCode(), (int)host1.hashCode());
        Assertions.assertNotEquals((int)host1.hashCode(), (int)host2.hashCode());
        Assertions.assertNotEquals((int)host1.hashCode(), (int)host3.hashCode());
        Assertions.assertEquals((int)host2.hashCode(), (int)host4.hashCode());
        Assertions.assertEquals((int)host2.hashCode(), (int)host5.hashCode());
        Assertions.assertNotEquals((int)host5.hashCode(), (int)host6.hashCode());
        Assertions.assertEquals((int)host6.hashCode(), (int)host7.hashCode());
    }

    @Test
    void testEquals() {
        URIAuthority host1 = new URIAuthority("somehost", 8080);
        URIAuthority host2 = new URIAuthority("somehost", 80);
        URIAuthority host3 = new URIAuthority("someotherhost", 8080);
        URIAuthority host4 = new URIAuthority("somehost", 80);
        URIAuthority host5 = new URIAuthority("SomeHost", 80);
        URIAuthority host6 = new URIAuthority("user", "SomeHost", 80);
        URIAuthority host7 = new URIAuthority("user", "somehost", 80);
        Assertions.assertEquals((Object)host1, (Object)host1);
        Assertions.assertNotEquals((Object)host1, (Object)host2);
        Assertions.assertNotEquals((Object)host1, (Object)host3);
        Assertions.assertEquals((Object)host2, (Object)host4);
        Assertions.assertEquals((Object)host2, (Object)host5);
        Assertions.assertNotEquals((Object)host5, (Object)host6);
        Assertions.assertEquals((Object)host6, (Object)host7);
    }

    @Test
    void testToString() {
        URIAuthority host1 = new URIAuthority("somehost");
        Assertions.assertEquals((Object)"somehost", (Object)host1.toString());
        URIAuthority host2 = new URIAuthority("somehost", -1);
        Assertions.assertEquals((Object)"somehost", (Object)host2.toString());
        URIAuthority host3 = new URIAuthority("somehost", 8888);
        Assertions.assertEquals((Object)"somehost:8888", (Object)host3.toString());
    }

    @Test
    void testSerialization() throws Exception {
        URIAuthority orig = new URIAuthority("somehost", 8080);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        URIAuthority clone = (URIAuthority)inStream.readObject();
        Assertions.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    void testParse() throws Exception {
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost/blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost?blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost#blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"aaaa@:8080"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("aaaa", "", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"@:"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority(null, "", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost:8080"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost:8080/blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost:8080?blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost:8080#blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"somehost:008080"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", 8080)));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"somehost:aaaaa"));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"somehost:90ab"));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost/blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost?blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost#blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:/blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:?blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:#blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", -1)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:8080"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:8080/blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:8080?blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"someuser@somehost:8080#blah"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("someuser", "somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"@somehost:8080"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("somehost", 8080)));
        MatcherAssert.assertThat((Object)URIAuthority.parse((CharSequence)"test:test@localhost:38339"), (Matcher)CoreMatchers.equalTo((Object)new URIAuthority("test:test", "localhost", 38339)));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"blah@goggle.com:80@google.com/"));
    }

    @Test
    void testCreateFromString() throws Exception {
        Assertions.assertEquals((Object)new URIAuthority("somehost", 8080), (Object)URIAuthority.create((String)"somehost:8080"));
        Assertions.assertEquals((Object)new URIAuthority("SomeHost", 8080), (Object)URIAuthority.create((String)"SomeHost:8080"));
        Assertions.assertEquals((Object)new URIAuthority("somehost", 1234), (Object)URIAuthority.create((String)"somehost:1234"));
        Assertions.assertEquals((Object)new URIAuthority("somehost", -1), (Object)URIAuthority.create((String)"somehost"));
        Assertions.assertEquals((Object)new URIAuthority("user", "somehost", -1), (Object)URIAuthority.create((String)"user@somehost"));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)" host"));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"host  "));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"host :8080"));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"user @ host:8080"));
    }

    @Test
    void testCreateFromIPv6String() throws Exception {
        Assertions.assertEquals((Object)new URIAuthority("::1", 8080), (Object)URIAuthority.create((String)"[::1]:8080"));
        Assertions.assertEquals((Object)new URIAuthority("::1", -1), (Object)URIAuthority.create((String)"[::1]"));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"::1"));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"[::1"));
        Assertions.assertThrows(URISyntaxException.class, () -> URIAuthority.create((String)"[a]:8080"));
    }

    @Test
    void testIpv6HostToString() {
        Assertions.assertEquals((Object)"[::1]:80", (Object)new URIAuthority("::1", 80).toString());
        Assertions.assertEquals((Object)"user@[::1]:80", (Object)new URIAuthority("user", "::1", 80).toString());
        Assertions.assertEquals((Object)"[::1]", (Object)new URIAuthority("::1", -1).toString());
        Assertions.assertEquals((Object)"user@[::1]", (Object)new URIAuthority("user", "::1", -1).toString());
    }
}

