/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { NgModule, Type } from '@angular/core';
import { SharedModule } from '@shared';
import { NzBreadCrumbModule } from 'ng-zorro-antd/breadcrumb';
import { NzDatePickerModule } from 'ng-zorro-antd/date-picker';
import { NzEmptyModule } from 'ng-zorro-antd/empty';
import { NzPaginationModule } from 'ng-zorro-antd/pagination';
import { NzTableModule } from 'ng-zorro-antd/table';
import { NzTagModule } from 'ng-zorro-antd/tag';

import { LogIntegrationComponent } from './log-integration/log-integration.component';
import { LogManageComponent } from './log-manage/log-manage.component';
import { LogRoutingModule } from './log-routing.module';
import { LogStreamComponent } from './log-stream/log-stream.component';

const COMPONENTS: Array<Type<void>> = [];

@NgModule({
  imports: [
    SharedModule,
    LogRoutingModule,
    NzTableModule,
    NzTagModule,
    NzDatePickerModule,
    NzPaginationModule,
    NzEmptyModule,
    NzBreadCrumbModule,
    LogIntegrationComponent,
    LogStreamComponent,
    LogManageComponent
  ],
  declarations: COMPONENTS
})
export class LogModule {}
