/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.IdealState;
import org.apache.helix.participant.CustomCodeCallbackHandler;
import org.apache.helix.participant.GenericLeaderStandbyStateModelFactory;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HelixCustomCodeRunner {
    private static final String LEADER_STANDBY = "LeaderStandby";
    private static Logger LOG = LoggerFactory.getLogger(HelixCustomCodeRunner.class);
    private static String PARTICIPANT_LEADER = "PARTICIPANT_LEADER";
    private CustomCodeCallbackHandler _callback;
    private List<HelixConstants.ChangeType> _notificationTypes;
    private String _resourceName;
    private final HelixManager _manager;
    private final String _zkAddr;
    private final RealmAwareZkClient.RealmAwareZkConnectionConfig _connectionConfig;
    private GenericLeaderStandbyStateModelFactory _stateModelFty;

    public HelixCustomCodeRunner(HelixManager manager, String zkAddr) {
        this._manager = manager;
        this._zkAddr = zkAddr;
        this._connectionConfig = null;
    }

    public HelixCustomCodeRunner(HelixManager manager, RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig) {
        this._manager = manager;
        this._zkAddr = null;
        this._connectionConfig = connectionConfig;
    }

    public HelixCustomCodeRunner invoke(CustomCodeCallbackHandler callback) {
        this._callback = callback;
        return this;
    }

    public HelixCustomCodeRunner on(HelixConstants.ChangeType ... notificationTypes) {
        this._notificationTypes = Arrays.asList(notificationTypes);
        return this;
    }

    public HelixCustomCodeRunner usingLeaderStandbyModel(String id) {
        this._resourceName = PARTICIPANT_LEADER + "_" + id;
        return this;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this._callback == null || this._notificationTypes == null || this._notificationTypes.size() == 0 || this._resourceName == null) {
            throw new IllegalArgumentException("Require callback | notificationTypes | resourceName");
        }
        LOG.info("Register participantLeader on " + this._notificationTypes + " using " + this._resourceName);
        this._stateModelFty = new GenericLeaderStandbyStateModelFactory(this._callback, this._notificationTypes);
        StateMachineEngine stateMach = this._manager.getStateMachineEngine();
        stateMach.registerStateModelFactory(LEADER_STANDBY, this._stateModelFty, this._resourceName);
        RealmAwareZkClient zkClient = null;
        try {
            RealmAwareZkClient.RealmAwareZkClientConfig clientConfig;
            if (Boolean.getBoolean("helix.multiZkEnabled") || this._zkAddr == null) {
                clientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig();
                clientConfig.setZkSerializer(new ZNRecordSerializer());
                zkClient = new FederatedZkClient(this._connectionConfig, clientConfig);
            } else {
                clientConfig = new HelixZkClient.ZkClientConfig();
                ((HelixZkClient.ZkClientConfig)clientConfig).setZkSerializer(new ZNRecordSerializer());
                zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(this._zkAddr), (HelixZkClient.ZkClientConfig)clientConfig);
            }
            ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(this._manager.getClusterName(), new ZkBaseDataAccessor<ZNRecord>(zkClient));
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            IdealState idealState = new IdealState(this._resourceName);
            idealState.setRebalanceMode(IdealState.RebalanceMode.SEMI_AUTO);
            idealState.setReplicas(IdealState.IdealStateConstants.ANY_LIVEINSTANCE.toString());
            idealState.setNumPartitions(1);
            idealState.setStateModelDefRef(LEADER_STANDBY);
            idealState.setStateModelFactoryName(this._resourceName);
            ArrayList<String> prefList = new ArrayList<String>(Arrays.asList(IdealState.IdealStateConstants.ANY_LIVEINSTANCE.toString()));
            idealState.getRecord().setListField(this._resourceName + "_0", prefList);
            List<String> idealStates = accessor.getChildNames(keyBuilder.idealStates());
            while (idealStates == null || !idealStates.contains(this._resourceName)) {
                accessor.setProperty(keyBuilder.idealStates(this._resourceName), idealState);
                idealStates = accessor.getChildNames(keyBuilder.idealStates());
            }
            LOG.info("Set idealState for participantLeader:" + this._resourceName + ", idealState:" + idealState);
        }
        finally {
            if (zkClient != null && !zkClient.isClosed()) {
                zkClient.close();
            }
        }
    }

    public void stop() {
        LOG.info("Removing stateModelFactory for " + this._resourceName);
        this._manager.getStateMachineEngine().removeStateModelFactory(LEADER_STANDBY, this._stateModelFty, this._resourceName);
    }
}

