/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.metrics;

import javax.management.JMException;
import org.apache.helix.HelixException;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.metrics.MetricCollector;
import org.apache.helix.monitoring.metrics.implementation.RebalanceCounter;

public class AbnormalStatesMetricCollector
extends MetricCollector {
    private static final String ABNORMAL_STATES_ENTITY_NAME = "AbnormalStates";

    public AbnormalStatesMetricCollector(String clusterName, String stateModelDef) {
        super(MonitorDomainNames.Rebalancer.name(), clusterName, String.format("%s.%s", ABNORMAL_STATES_ENTITY_NAME, stateModelDef));
        this.createMetrics();
        if (clusterName != null) {
            try {
                this.register();
            }
            catch (JMException e) {
                throw new HelixException("Failed to register MBean for the " + AbnormalStatesMetricCollector.class.getSimpleName(), e);
            }
        }
    }

    private void createMetrics() {
        RebalanceCounter abnormalStateReplicasCounter = new RebalanceCounter(AbnormalStatesMetricNames.AbnormalStatePartitionCounter.name());
        RebalanceCounter RecoveryAttemptCounter = new RebalanceCounter(AbnormalStatesMetricNames.RecoveryAttemptCounter.name());
        this.addMetric(abnormalStateReplicasCounter);
        this.addMetric(RecoveryAttemptCounter);
    }

    public static enum AbnormalStatesMetricNames {
        AbnormalStatePartitionCounter,
        RecoveryAttemptCounter;

    }
}

