/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.helix.store.zk.ZNode;
import org.apache.helix.util.HelixUtil;
import org.apache.zookeeper.data.Stat;

public abstract class Cache<T> {
    final ReadWriteLock _lock = new ReentrantReadWriteLock();
    final ConcurrentHashMap<String, ZNode> _cache = new ConcurrentHashMap();

    public void addToParentChildSet(String parentPath, String childName) {
        ZNode znode = this._cache.get(parentPath);
        if (znode != null) {
            znode.addChild(childName);
        }
    }

    public void addToParentChildSet(String parentPath, List<String> childNames) {
        ZNode znode;
        if (childNames != null && !childNames.isEmpty() && (znode = this._cache.get(parentPath)) != null) {
            znode.addChildren(childNames);
        }
    }

    public void removeFromParentChildSet(String parentPath, String name) {
        ZNode zNode = this._cache.get(parentPath);
        if (zNode != null) {
            zNode.removeChild(name);
        }
    }

    public boolean exists(String path) {
        return this._cache.containsKey(path);
    }

    public ZNode get(String path) {
        try {
            this._lock.readLock().lock();
            ZNode zNode = this._cache.get(path);
            return zNode;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void lockWrite() {
        this._lock.writeLock().lock();
    }

    public void unlockWrite() {
        this._lock.writeLock().unlock();
    }

    public void lockRead() {
        this._lock.readLock().lock();
    }

    public void unlockRead() {
        this._lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeRecursive(String path) {
        try {
            this._lock.writeLock().lock();
            String parentPath = HelixUtil.getZkParentPath(path);
            String name = HelixUtil.getZkName(path);
            this.removeFromParentChildSet(parentPath, name);
            ZNode znode = this._cache.remove(path);
            if (znode != null) {
                Set<String> childNames = znode.getChildSet();
                for (String childName : childNames) {
                    String childPath = path + "/" + childName;
                    this.purgeRecursive(childPath);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void reset() {
        try {
            this._lock.writeLock().lock();
            this._cache.clear();
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public abstract void update(String var1, T var2, Stat var3);

    public abstract void updateRecursive(String var1);

    public Map<String, ZNode> getCache() {
        return this._cache;
    }
}

