/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.rebalancer.CustomRebalancer;
import org.apache.helix.controller.rebalancer.DelayedAutoRebalancer;
import org.apache.helix.controller.rebalancer.MaintenanceRebalancer;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.SemiAutoRebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.ReadOnlyWagedRebalancer;
import org.apache.helix.controller.rebalancer.waged.WagedRebalancer;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.monitoring.mbeans.ResourceMonitor;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestPossibleStateCalcStage
extends AbstractBaseStage {
    private static final Logger logger = LoggerFactory.getLogger((String)BestPossibleStateCalcStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE_EXCLUDING_UNKNOWN.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (currentStateOutput == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires CURRENT_STATE_EXCLUDING_UNKNOWN|RESOURCES|DataCache");
        }
        BestPossibleStateOutput bestPossibleStateOutput = this.compute(event, resourceMap, currentStateOutput);
        this.addSwapInInstancesToBestPossibleState(resourceMap, bestPossibleStateOutput, cache);
        event.addAttribute(AttributeName.BEST_POSSIBLE_STATE.name(), bestPossibleStateOutput);
        Map<String, InstanceConfig> allInstanceConfigMap = cache.getInstanceConfigMap();
        Map<String, StateModelDefinition> stateModelDefMap = cache.getStateModelDefMap();
        Map<String, IdealState> idealStateMap = cache.getIdealStates();
        Map<String, ExternalView> externalViewMap = cache.getExternalViews();
        Map<String, ResourceConfig> resourceConfigMap = cache.getResourceConfigMap();
        BestPossibleStateCalcStage.asyncExecute(cache.getAsyncTasksThreadPool(), () -> {
            try {
                if (clusterStatusMonitor != null) {
                    clusterStatusMonitor.setPerInstanceResourceStatus(bestPossibleStateOutput, allInstanceConfigMap, resourceMap, stateModelDefMap);
                    for (String resourceName : idealStateMap.keySet()) {
                        if (resourceConfigMap.containsKey(resourceName) && ((ResourceConfig)resourceConfigMap.get(resourceName)).isMonitoringDisabled().booleanValue()) continue;
                        IdealState is = (IdealState)idealStateMap.get(resourceName);
                        this.reportResourceState(clusterStatusMonitor, bestPossibleStateOutput, resourceName, is, (ExternalView)externalViewMap.get(resourceName), (StateModelDefinition)stateModelDefMap.get(is.getStateModelDefRef()));
                    }
                }
            }
            catch (Exception e) {
                LogUtil.logError(logger, this._eventId, "Could not update cluster status metrics!", e);
            }
            return null;
        });
    }

    private String selectSwapInState(StateModelDefinition stateModelDef, Map<String, String> stateMap, String swapOutInstance, String swapInInstance, String resource, String partition, ResourceControllerDataProvider cache) {
        if (stateMap.containsKey(swapOutInstance)) {
            if (cache.getDisabledInstancesForPartition(resource, partition).contains(swapInInstance)) {
                return stateModelDef.getInitialState();
            }
            if (stateMap.get(swapOutInstance).equals(stateModelDef.getTopState()) || stateMap.get(swapOutInstance).equals(HelixDefinedState.ERROR.name())) {
                String topStateCount = stateModelDef.getNumInstancesPerState(stateModelDef.getTopState());
                if (topStateCount.equals("N") || topStateCount.equals("R")) {
                    return stateModelDef.getTopState();
                }
                return stateModelDef.getSecondTopStates().iterator().next();
            }
            return stateMap.get(swapOutInstance);
        }
        return null;
    }

    private void addSwapInInstancesToBestPossibleState(Map<String, Resource> resourceMap, BestPossibleStateOutput bestPossibleStateOutput, ResourceControllerDataProvider cache) {
        Map<String, String> swapOutToSwapInInstancePairs = cache.getSwapOutToSwapInInstancePairs();
        Map<String, String> swapInToSwapOutInstancePairs = cache.getSwapInToSwapOutInstancePairs();
        Set<String> liveSwapInInstances = cache.getLiveSwapInInstanceNames();
        if (liveSwapInInstances.isEmpty() || cache.isMaintenanceModeEnabled()) {
            return;
        }
        HashMap<String, Map> swapInInstanceAssignment = new HashMap<String, Map>();
        resourceMap.forEach((resourceName, resource) -> bestPossibleStateOutput.getResourceStatesMap().get(resourceName).getStateMap().forEach((partition, stateMap) -> {
            HashSet<String> commonInstances;
            HashSet<String> hashSet = commonInstances = bestPossibleStateOutput.getInstanceStateMap((String)resourceName, (Partition)partition) != null ? new HashSet<String>(bestPossibleStateOutput.getInstanceStateMap((String)resourceName, (Partition)partition).keySet()) : Collections.emptySet();
            if (commonInstances.isEmpty()) {
                return;
            }
            commonInstances.retainAll(swapOutToSwapInInstancePairs.keySet());
            commonInstances.forEach(swapOutInstance -> swapInInstanceAssignment.computeIfAbsent((String)swapOutToSwapInInstancePairs.get(swapOutInstance), k -> new HashMap()).computeIfAbsent(resourceName, k -> new HashSet()).add(partition.getPartitionName()));
        }));
        if (!swapInInstanceAssignment.isEmpty()) {
            swapInInstanceAssignment.forEach((swapInInstance, resourceMapForInstance) -> {
                if (!liveSwapInInstances.contains(swapInInstance)) {
                    return;
                }
                resourceMapForInstance.forEach((resourceName, partitions) -> partitions.forEach(partitionName -> {
                    Partition partition = new Partition((String)partitionName);
                    Map<String, String> stateMap = bestPossibleStateOutput.getInstanceStateMap((String)resourceName, partition);
                    String selectedState = this.selectSwapInState(cache.getStateModelDef(((Resource)resourceMap.get(resourceName)).getStateModelDefRef()), stateMap, (String)swapInToSwapOutInstancePairs.get(swapInInstance), (String)swapInInstance, (String)resourceName, partition.getPartitionName(), cache);
                    if (selectedState != null) {
                        bestPossibleStateOutput.setState((String)resourceName, partition, (String)swapInInstance, selectedState);
                    }
                }));
            });
        }
    }

    private void reportResourceState(ClusterStatusMonitor clusterStatusMonitor, BestPossibleStateOutput bestPossibleStateOutput, String resourceName, IdealState is, ExternalView ev, StateModelDefinition stateModelDef) {
        IdealState tmpIdealState = new IdealState(is.getRecord());
        if (bestPossibleStateOutput.containsResource(resourceName)) {
            Map<String, List<String>> preferenceLists = bestPossibleStateOutput.getPreferenceLists(resourceName);
            tmpIdealState.getRecord().setListFields(preferenceLists);
            Map<Partition, Map<String, String>> stateMap = bestPossibleStateOutput.getPartitionStateMap(resourceName).getStateMap();
            tmpIdealState.getRecord().setMapFields(stateMap.entrySet().stream().collect(Collectors.toMap(e -> ((Partition)e.getKey()).getPartitionName(), Map.Entry::getValue)));
        } else {
            LogUtil.logWarn(logger, this._eventId, String.format("Cannot find the best possible state of resource %s. Will update the resource status based on the content of the IdealState.", resourceName));
        }
        clusterStatusMonitor.setResourceState(resourceName, ev, tmpIdealState, stateModelDef);
    }

    private BestPossibleStateOutput compute(ClusterEvent event, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) {
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        BestPossibleStateOutput output = new BestPossibleStateOutput();
        HelixManager helixManager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        WagedRebalancer wagedRebalancer = (WagedRebalancer)event.getAttribute(AttributeName.STATEFUL_REBALANCER.name());
        boolean isValid = this.validateInstancesUnableToAcceptOnlineReplicasLimit(cache, (HelixManager)event.getAttribute(AttributeName.helixmanager.name()));
        ArrayList<String> failureResources = new ArrayList<String>();
        Map<String, Resource> calculatedResourceMap = this.computeResourceBestPossibleStateWithWagedRebalancer(wagedRebalancer, cache, currentStateOutput, resourceMap, output, failureResources);
        HashMap<String, Resource> remainingResourceMap = new HashMap<String, Resource>(resourceMap);
        remainingResourceMap.keySet().removeAll(calculatedResourceMap.keySet());
        for (Resource resource : remainingResourceMap.values()) {
            boolean result = false;
            try {
                result = this.computeSingleResourceBestPossibleState(event, cache, currentStateOutput, resource, output);
            }
            catch (HelixException ex) {
                LogUtil.logError(logger, this._eventId, String.format("Exception when calculating best possible states for %s", resource.getResourceName()), ex);
            }
            if (result) continue;
            failureResources.add(resource.getResourceName());
            LogUtil.logWarn(logger, this._eventId, String.format("Failed to calculate best possible states for %s", resource.getResourceName()));
        }
        this.updateRebalanceStatus(!isValid || !failureResources.isEmpty(), failureResources, helixManager, cache, clusterStatusMonitor, String.format("Failed to calculate best possible states for %d resources.", failureResources.size()));
        return output;
    }

    private void updateRebalanceStatus(final boolean hasFailure, final List<String> failedResources, HelixManager helixManager, ResourceControllerDataProvider cache, final ClusterStatusMonitor clusterStatusMonitor, final String errorMessage) {
        BestPossibleStateCalcStage.asyncExecute(cache.getAsyncTasksThreadPool(), new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    if (hasFailure) {
                        LogUtil.logWarn(logger, BestPossibleStateCalcStage.this._eventId, errorMessage);
                    }
                    if (clusterStatusMonitor != null) {
                        clusterStatusMonitor.setRebalanceFailureGauge(hasFailure);
                        clusterStatusMonitor.setResourceRebalanceStates(failedResources, ResourceMonitor.RebalanceStatus.BEST_POSSIBLE_STATE_CAL_FAILED);
                    }
                }
                catch (Exception e) {
                    LogUtil.logError(logger, BestPossibleStateCalcStage.this._eventId, "Could not update cluster status!", e);
                }
                return null;
            }
        });
    }

    private boolean validateInstancesUnableToAcceptOnlineReplicasLimit(ResourceControllerDataProvider cache, HelixManager manager) {
        int instancesUnableToAcceptOnlineReplicas;
        int maxInstancesUnableToAcceptOnlineReplicas = cache.getClusterConfig().getMaxOfflineInstancesAllowed();
        if (maxInstancesUnableToAcceptOnlineReplicas >= 0 && (instancesUnableToAcceptOnlineReplicas = cache.getInstanceConfigMap().entrySet().stream().filter(instanceEntry -> !InstanceConstants.UNROUTABLE_INSTANCE_OPERATIONS.contains((Object)((InstanceConfig)instanceEntry.getValue()).getInstanceOperation().getOperation())).collect(Collectors.toSet()).size() - cache.getEnabledLiveInstances().size()) > maxInstancesUnableToAcceptOnlineReplicas) {
            String errMsg = String.format("Instances unable to take ONLINE replicas count %d greater than allowed count %d. Put cluster %s into maintenance mode.", instancesUnableToAcceptOnlineReplicas, maxInstancesUnableToAcceptOnlineReplicas, cache.getClusterName());
            if (manager != null) {
                if (manager.getHelixDataAccessor().getProperty(manager.getHelixDataAccessor().keyBuilder().maintenance()) == null) {
                    manager.getClusterManagmentTool().autoEnableMaintenanceMode(manager.getClusterName(), true, errMsg, MaintenanceSignal.AutoTriggerReason.MAX_INSTANCES_UNABLE_TO_ACCEPT_ONLINE_REPLICAS);
                    LogUtil.logWarn(logger, this._eventId, errMsg);
                }
            } else {
                LogUtil.logError(logger, this._eventId, "Failed to put cluster " + cache.getClusterName() + " into maintenance mode, HelixManager is not set!");
            }
            cache.enableMaintenanceMode();
            return false;
        }
        return true;
    }

    private void updateWagedRebalancer(WagedRebalancer wagedRebalancer, ClusterConfig clusterConfig) {
        if (clusterConfig != null) {
            wagedRebalancer.updateRebalancePreference(clusterConfig.getGlobalRebalancePreference());
            wagedRebalancer.setGlobalRebalanceAsyncMode(clusterConfig.isGlobalRebalanceAsyncModeEnabled());
        }
    }

    private Map<String, Resource> computeResourceBestPossibleStateWithWagedRebalancer(WagedRebalancer wagedRebalancer, ResourceControllerDataProvider cache, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap, BestPossibleStateOutput output, List<String> failureResources) {
        if (cache.isMaintenanceModeEnabled() && !(wagedRebalancer instanceof ReadOnlyWagedRebalancer)) {
            return Collections.emptyMap();
        }
        Map<String, Resource> wagedRebalancedResourceMap = resourceMap.entrySet().stream().filter(resourceEntry -> WagedValidationUtil.isWagedEnabled(cache.getIdealState((String)resourceEntry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, IdealState> newIdealStates = new HashMap<String, IdealState>();
        if (wagedRebalancer != null) {
            this.updateWagedRebalancer(wagedRebalancer, cache.getClusterConfig());
            try {
                newIdealStates.putAll(wagedRebalancer.computeNewIdealStates(cache, wagedRebalancedResourceMap, currentStateOutput));
            }
            catch (HelixRebalanceException ex) {
                LogUtil.logError(logger, this._eventId, String.format("Failed to calculate the new Ideal States using the rebalancer %s due to %s", new Object[]{wagedRebalancer.getClass().getSimpleName(), ex.getFailureType()}), ex);
            }
        } else {
            LogUtil.logWarn(logger, this._eventId, "Skip rebalancing using the WAGED rebalancer since it is not configured in the rebalance pipeline.");
        }
        for (Resource resource : wagedRebalancedResourceMap.values()) {
            IdealState is = (IdealState)newIdealStates.get(resource.getResourceName());
            if (is != null && this.checkBestPossibleStateCalculation(is)) {
                this.updateBestPossibleStateOutput(output, resource, is);
                continue;
            }
            failureResources.add(resource.getResourceName());
            LogUtil.logWarn(logger, this._eventId, String.format("The calculated best possible states for %s is empty or invalid.", resource.getResourceName()));
        }
        return wagedRebalancedResourceMap;
    }

    private void updateBestPossibleStateOutput(BestPossibleStateOutput output, Resource resource, IdealState computedIdealState) {
        output.setPreferenceLists(resource.getResourceName(), computedIdealState.getPreferenceLists());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> newStateMap = computedIdealState.getInstanceStateMap(partition.getPartitionName());
            output.setState(resource.getResourceName(), partition, newStateMap);
        }
    }

    private boolean computeSingleResourceBestPossibleState(ClusterEvent event, ResourceControllerDataProvider cache, CurrentStateOutput currentStateOutput, Resource resource, BestPossibleStateOutput output) {
        String resourceName = resource.getResourceName();
        LogUtil.logDebug(logger, this._eventId, "Processing resource:" + resourceName);
        IdealState idealState = cache.getIdealState(resourceName);
        if (idealState == null) {
            LogUtil.logInfo(logger, this._eventId, "resource:" + resourceName + " does not exist anymore");
            idealState = new IdealState(resourceName);
            idealState.setStateModelDefRef(resource.getStateModelDefRef());
        }
        if (idealState.getStateModelDefRef().equals("Task")) {
            LogUtil.logWarn(logger, this._eventId, String.format("Resource %s should not be processed by %s pipeline", resourceName, cache.getPipelineName()));
            return false;
        }
        Rebalancer<ResourceControllerDataProvider> rebalancer = this.getRebalancer(idealState, resourceName, cache.isMaintenanceModeEnabled());
        MappingCalculator<ResourceControllerDataProvider> mappingCalculator = this.getMappingCalculator(rebalancer, resourceName);
        if (rebalancer == null) {
            LogUtil.logError(logger, this._eventId, "Error computing assignment for resource " + resourceName + ". no rebalancer found. rebalancer: " + rebalancer + " mappingCalculator: " + mappingCalculator);
        } else {
            try {
                HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
                rebalancer.init(manager);
                idealState = rebalancer.computeNewIdealState(resourceName, idealState, currentStateOutput, cache);
                if (!this.checkBestPossibleStateCalculation(idealState)) {
                    LogUtil.logWarn(logger, this._eventId, "The calculated idealState is not valid, resource: " + resourceName);
                    return false;
                }
                ResourceAssignment partitionStateAssignment = mappingCalculator.computeBestPossiblePartitionState(cache, idealState, resource, currentStateOutput);
                if (partitionStateAssignment == null) {
                    LogUtil.logWarn(logger, this._eventId, "The calculated partitionStateAssignment is null, resource: " + resourceName);
                    return false;
                }
                output.setPreferenceLists(resourceName, idealState.getPreferenceLists());
                for (Partition partition : resource.getPartitions()) {
                    Map<String, String> newStateMap = partitionStateAssignment.getReplicaMap(partition);
                    output.setState(resourceName, partition, newStateMap);
                }
                return true;
            }
            catch (HelixException e) {
                LogUtil.logError(logger, this._eventId, e.getMessage());
            }
            catch (Exception e) {
                LogUtil.logError(logger, this._eventId, "Error computing assignment for resource " + resourceName + ". Skipping.", e);
            }
        }
        return false;
    }

    private boolean checkBestPossibleStateCalculation(IdealState idealState) {
        if (idealState.getRebalanceMode() == IdealState.RebalanceMode.FULL_AUTO && !idealState.getReplicas().equals("0")) {
            Map<String, List<String>> preferenceLists = idealState.getPreferenceLists();
            if (preferenceLists == null || preferenceLists.isEmpty()) {
                return false;
            }
            int emptyListCount = 0;
            for (List<String> preferenceList : preferenceLists.values()) {
                if (!preferenceList.isEmpty()) continue;
                ++emptyListCount;
            }
            return emptyListCount != preferenceLists.values().size();
        }
        return true;
    }

    private Rebalancer<ResourceControllerDataProvider> getCustomizedRebalancer(String rebalancerClassName, String resourceName) {
        Rebalancer customizedRebalancer = null;
        if (rebalancerClassName != null) {
            if (logger.isDebugEnabled()) {
                LogUtil.logDebug(logger, this._eventId, "resource " + resourceName + " use idealStateRebalancer " + rebalancerClassName);
            }
            try {
                customizedRebalancer = (Rebalancer)Rebalancer.class.cast(HelixUtil.loadClass(this.getClass(), rebalancerClassName).newInstance());
            }
            catch (Exception e) {
                LogUtil.logError(logger, this._eventId, "Exception while invoking custom rebalancer class:" + rebalancerClassName, e);
            }
        }
        return customizedRebalancer;
    }

    private Rebalancer<ResourceControllerDataProvider> getRebalancer(IdealState idealState, String resourceName, boolean isMaintenanceModeEnabled) {
        Rebalancer<ResourceControllerDataProvider> rebalancer = null;
        switch (idealState.getRebalanceMode()) {
            case FULL_AUTO: {
                if (isMaintenanceModeEnabled) {
                    rebalancer = new MaintenanceRebalancer();
                    break;
                }
                Rebalancer<ResourceControllerDataProvider> customizedRebalancer = this.getCustomizedRebalancer(idealState.getRebalancerClassName(), resourceName);
                if (customizedRebalancer != null) {
                    rebalancer = customizedRebalancer;
                    break;
                }
                rebalancer = new DelayedAutoRebalancer();
                break;
            }
            case SEMI_AUTO: {
                rebalancer = new SemiAutoRebalancer();
                break;
            }
            case CUSTOMIZED: {
                rebalancer = new CustomRebalancer();
                break;
            }
            case USER_DEFINED: 
            case TASK: {
                rebalancer = this.getCustomizedRebalancer(idealState.getRebalancerClassName(), resourceName);
                break;
            }
            default: {
                LogUtil.logError(logger, this._eventId, "Fail to find the rebalancer, invalid rebalance mode " + idealState.getRebalanceMode());
            }
        }
        return rebalancer;
    }

    private MappingCalculator<ResourceControllerDataProvider> getMappingCalculator(Rebalancer<ResourceControllerDataProvider> rebalancer, String resourceName) {
        SemiAutoRebalancer mappingCalculator = null;
        if (rebalancer != null) {
            try {
                mappingCalculator = (SemiAutoRebalancer)MappingCalculator.class.cast(rebalancer);
            }
            catch (ClassCastException e) {
                LogUtil.logWarn(logger, this._eventId, "Rebalancer does not have a mapping calculator, defaulting to SEMI_AUTO, resource: " + resourceName);
            }
        }
        if (mappingCalculator == null) {
            mappingCalculator = new SemiAutoRebalancer();
        }
        return mappingCalculator;
    }
}

