/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.waged.AssignmentMetadataStore;
import org.apache.helix.controller.rebalancer.waged.WagedRebalancer;
import org.apache.helix.controller.rebalancer.waged.constraints.ConstraintBasedAlgorithmFactory;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ResourceAssignment;

public class ReadOnlyWagedRebalancer
extends WagedRebalancer {
    public ReadOnlyWagedRebalancer(ZkBucketDataAccessor zkBucketDataAccessor, String clusterName, Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> preferences) {
        super(new ReadOnlyAssignmentMetadataStore(zkBucketDataAccessor, clusterName), ConstraintBasedAlgorithmFactory.getInstance(preferences), Optional.empty());
    }

    @Override
    protected List<HelixRebalanceException.Type> failureTypesToPropagate() {
        ArrayList<HelixRebalanceException.Type> failureTypes = new ArrayList<HelixRebalanceException.Type>(super.failureTypesToPropagate());
        failureTypes.add(HelixRebalanceException.Type.FAILED_TO_CALCULATE);
        return failureTypes;
    }

    public void updateChangeDetectorSnapshots(ResourceControllerDataProvider dataProvider) {
        this.getChangeDetector().updateSnapshots(dataProvider);
    }

    private static class ReadOnlyAssignmentMetadataStore
    extends AssignmentMetadataStore {
        ReadOnlyAssignmentMetadataStore(ZkBucketDataAccessor zkBucketDataAccessor, String clusterName) {
            super(zkBucketDataAccessor, clusterName);
        }

        @Override
        public void persistBaseline(Map<String, ResourceAssignment> globalBaseline) {
            this._globalBaseline = globalBaseline;
        }

        @Override
        public void persistBestPossibleAssignment(Map<String, ResourceAssignment> bestPossibleAssignment) {
            this._bestPossibleAssignment = bestPossibleAssignment;
            ++this._bestPossibleVersion;
        }

        @Override
        public synchronized boolean asyncUpdateBestPossibleAssignmentCache(Map<String, ResourceAssignment> bestPossibleAssignment, int newVersion) {
            if (newVersion > this._bestPossibleVersion) {
                this._bestPossibleAssignment = bestPossibleAssignment;
                this._bestPossibleVersion = newVersion;
                return true;
            }
            return false;
        }
    }
}

