/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixAdmin;
import org.apache.helix.api.rebalancer.constraint.dataprovider.CapacityProvider;
import org.apache.helix.api.rebalancer.constraint.dataprovider.PartitionWeightProvider;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.controller.rebalancer.constraint.PartitionWeightAwareEvennessConstraint;
import org.apache.helix.controller.rebalancer.constraint.TotalCapacityConstraint;
import org.apache.helix.controller.rebalancer.constraint.dataprovider.ZkBasedCapacityProvider;
import org.apache.helix.controller.rebalancer.constraint.dataprovider.ZkBasedPartitionWeightProvider;
import org.apache.helix.examples.ExampleHelper;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.util.WeightAwareRebalanceUtil;
import org.apache.helix.zookeeper.zkclient.ZkServer;

public class WeightAwareRebalanceUtilExample {
    private static String ZK_ADDRESS = "localhost:2199";
    private static String CLUSTER_NAME = "RebalanceUtilExampleCluster";
    private static HelixAdmin admin;
    static final String resourceNamePrefix = "resource";
    static final int nParticipants = 9;
    static final int nResources = 10;
    static final int nPartitions = 10;
    static final int nReplicas = 3;
    static final int defaultCapacity = 500;
    static final int resourceWeight = 10;
    static final List<String> resourceNames;
    static final List<String> instanceNames;
    static final List<String> partitions;
    static final List<ResourceConfig> resourceConfigs;
    static final ClusterConfig clusterConfig;
    static final List<InstanceConfig> instanceConfigs;

    private static void printAssignmentInfo(ResourcesStateMap assignment) {
        System.out.println("The result assignment is: ");
        HashMap<String, Integer> instanceLoad = new HashMap<String, Integer>();
        for (String resource : assignment.getResourceStatesMap().keySet()) {
            System.out.println(resource + ": " + assignment.getPartitionStateMap(resource).toString());
            for (Map<String, String> stateMap : assignment.getPartitionStateMap(resource).getStateMap().values()) {
                for (String instance : stateMap.keySet()) {
                    if (!instanceLoad.containsKey(instance)) {
                        instanceLoad.put(instance, 0);
                    }
                    instanceLoad.put(instance, (Integer)instanceLoad.get(instance) + 10);
                }
            }
        }
        System.out.println("Instance load: " + instanceLoad + "\n");
    }

    private static void rebalanceUtilUsage() {
        System.out.println(String.format("Start rebalancing using WeightAwareRebalanceUtil for %d resources.", 10));
        PartitionWeightProvider weightProvider = new PartitionWeightProvider(){

            @Override
            public int getPartitionWeight(String resource, String partition) {
                return 10;
            }
        };
        CapacityProvider capacityProvider = new CapacityProvider(){

            @Override
            public int getParticipantCapacity(String participant) {
                return 500;
            }

            @Override
            public int getParticipantUsage(String participant) {
                return 0;
            }
        };
        TotalCapacityConstraint capacityConstraint = new TotalCapacityConstraint(weightProvider, capacityProvider);
        PartitionWeightAwareEvennessConstraint evenConstraint = new PartitionWeightAwareEvennessConstraint(weightProvider, capacityProvider);
        WeightAwareRebalanceUtil util = new WeightAwareRebalanceUtil(clusterConfig, instanceConfigs);
        ResourcesStateMap assignment = util.buildIncrementalRebalanceAssignment(resourceConfigs, null, Collections.singletonList(capacityConstraint), Collections.singletonList(evenConstraint));
        System.out.println(String.format("Finished rebalancing using WeightAwareRebalanceUtil for %d resources.", 10));
        WeightAwareRebalanceUtilExample.printAssignmentInfo(assignment);
    }

    private static void rebalanceUtilUsageWithZkBasedDataProvider() {
        System.out.println(String.format("Start rebalancing using WeightAwareRebalanceUtil and ZK based Capacity/Weight data providers for %d resources.", 10));
        ZkServer zkServer = ExampleHelper.startZkServer(ZK_ADDRESS);
        admin = new ZKHelixAdmin(ZK_ADDRESS);
        admin.addCluster(CLUSTER_NAME, true);
        ZkBasedPartitionWeightProvider qpsWeightProvider = new ZkBasedPartitionWeightProvider(ZK_ADDRESS, CLUSTER_NAME, "QPS");
        qpsWeightProvider.updateWeights(Collections.EMPTY_MAP, Collections.EMPTY_MAP, 10);
        ZkBasedCapacityProvider qpsCapacityProvider = new ZkBasedCapacityProvider(ZK_ADDRESS, CLUSTER_NAME, "QPS");
        qpsCapacityProvider.updateCapacity(Collections.EMPTY_MAP, Collections.EMPTY_MAP, 500);
        ZkBasedPartitionWeightProvider memoryWeightProvider = new ZkBasedPartitionWeightProvider(ZK_ADDRESS, CLUSTER_NAME, "MEM");
        memoryWeightProvider.updateWeights(Collections.EMPTY_MAP, Collections.EMPTY_MAP, 10);
        ZkBasedCapacityProvider memoryCapacityProvider = new ZkBasedCapacityProvider(ZK_ADDRESS, CLUSTER_NAME, "MEM");
        memoryCapacityProvider.updateCapacity(Collections.EMPTY_MAP, Collections.EMPTY_MAP, 500);
        qpsCapacityProvider.persistCapacity();
        qpsWeightProvider.persistWeights();
        memoryCapacityProvider.persistCapacity();
        memoryWeightProvider.persistWeights();
        qpsWeightProvider = new ZkBasedPartitionWeightProvider(ZK_ADDRESS, CLUSTER_NAME, "QPS");
        qpsCapacityProvider = new ZkBasedCapacityProvider(ZK_ADDRESS, CLUSTER_NAME, "QPS");
        memoryWeightProvider = new ZkBasedPartitionWeightProvider(ZK_ADDRESS, CLUSTER_NAME, "MEM");
        memoryCapacityProvider = new ZkBasedCapacityProvider(ZK_ADDRESS, CLUSTER_NAME, "MEM");
        PartitionWeightAwareEvennessConstraint qpsConstraint = new PartitionWeightAwareEvennessConstraint(qpsWeightProvider, qpsCapacityProvider);
        PartitionWeightAwareEvennessConstraint memoryConstraint = new PartitionWeightAwareEvennessConstraint(memoryWeightProvider, memoryCapacityProvider);
        ArrayList<PartitionWeightAwareEvennessConstraint> softConstraints = new ArrayList<PartitionWeightAwareEvennessConstraint>();
        softConstraints.add(qpsConstraint);
        softConstraints.add(memoryConstraint);
        WeightAwareRebalanceUtil util = new WeightAwareRebalanceUtil(clusterConfig, instanceConfigs);
        ResourcesStateMap assignment = util.buildIncrementalRebalanceAssignment(resourceConfigs, null, Collections.EMPTY_LIST, softConstraints);
        ExampleHelper.stopZkServer(zkServer);
        System.out.println(String.format("Finished rebalancing using WeightAwareRebalanceUtil and ZK based Capacity/Weight data providers for %d resources.", 10));
        WeightAwareRebalanceUtilExample.printAssignmentInfo(assignment);
    }

    private static void rebalanceWithFaultZone() {
        System.out.println(String.format("Start rebalancing using WeightAwareRebalanceUtil for %d resources in a topology aware cluster.", 10));
        ClusterConfig clusterConfig = new ClusterConfig(CLUSTER_NAME);
        clusterConfig.setTopologyAwareEnabled(true);
        clusterConfig.setTopology("/Rack/Host");
        clusterConfig.setFaultZoneType("Rack");
        ArrayList<InstanceConfig> instanceConfigs = new ArrayList<InstanceConfig>();
        for (int i = 0; i < instanceNames.size(); ++i) {
            String instance = instanceNames.get(i);
            InstanceConfig config = new InstanceConfig(instance);
            String domainStr = String.format("Rack=%s,Host=%s", i % 3, instance);
            config.setDomain(domainStr);
            instanceConfigs.add(config);
            System.out.println(String.format("Set instance %s domain to be %s.", instance, domainStr));
        }
        PartitionWeightProvider weightProvider = new PartitionWeightProvider(){

            @Override
            public int getPartitionWeight(String resource, String partition) {
                return 10;
            }
        };
        CapacityProvider capacityProvider = new CapacityProvider(){

            @Override
            public int getParticipantCapacity(String participant) {
                return 500;
            }

            @Override
            public int getParticipantUsage(String participant) {
                return 0;
            }
        };
        TotalCapacityConstraint capacityConstraint = new TotalCapacityConstraint(weightProvider, capacityProvider);
        PartitionWeightAwareEvennessConstraint evenConstraint = new PartitionWeightAwareEvennessConstraint(weightProvider, capacityProvider);
        WeightAwareRebalanceUtil util = new WeightAwareRebalanceUtil(clusterConfig, instanceConfigs);
        ResourcesStateMap assignment = util.buildIncrementalRebalanceAssignment(resourceConfigs, null, Collections.singletonList(capacityConstraint), Collections.singletonList(evenConstraint));
        System.out.println(String.format("Finished rebalancing using WeightAwareRebalanceUtil for %d resources in a topology aware cluster with %d fault zones.", 10, 3));
        WeightAwareRebalanceUtilExample.printAssignmentInfo(assignment);
    }

    private static void setup() {
        int i;
        for (i = 0; i < 9; ++i) {
            instanceNames.add("node" + i);
        }
        for (i = 0; i < 10; ++i) {
            partitions.add(Integer.toString(i));
        }
        for (i = 0; i < 10; ++i) {
            String resourceName = resourceNamePrefix + i;
            resourceNames.add(resourceName);
            ResourceConfig.Builder resourceBuilder = new ResourceConfig.Builder(resourceName);
            resourceBuilder.setStateModelDefRef("MasterSlave");
            resourceBuilder.setNumReplica(3);
            for (String partition : partitions) {
                resourceBuilder.setPreferenceList(partition, Collections.EMPTY_LIST);
            }
            resourceConfigs.add(resourceBuilder.build());
        }
        for (String instance : instanceNames) {
            InstanceConfig config = new InstanceConfig(instance);
            instanceConfigs.add(config);
        }
    }

    public static void main(String[] args) throws Exception {
        WeightAwareRebalanceUtilExample.setup();
        WeightAwareRebalanceUtilExample.rebalanceUtilUsage();
        WeightAwareRebalanceUtilExample.rebalanceUtilUsageWithZkBasedDataProvider();
        WeightAwareRebalanceUtilExample.rebalanceWithFaultZone();
    }

    static {
        resourceNames = new ArrayList<String>();
        instanceNames = new ArrayList<String>();
        partitions = new ArrayList<String>(10);
        resourceConfigs = new ArrayList<ResourceConfig>();
        clusterConfig = new ClusterConfig(CLUSTER_NAME);
        instanceConfigs = new ArrayList<InstanceConfig>();
    }
}

