/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import java.util.logging.Level;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.engine.component.HostRoute;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.routing.VirtualHost;

public class ServerRouter
extends Router {
    private volatile Component component;

    public ServerRouter(Component component) {
        super(component == null ? null : component.getContext().createChildContext());
        this.component = component;
        this.setRoutingMode(2);
    }

    private Component getComponent() {
        return this.component;
    }

    @Override
    protected void logRoute(Route route) {
        if (this.getLogger().isLoggable(Level.FINE)) {
            if (route instanceof HostRoute) {
                VirtualHost vhost = ((HostRoute)route).getVirtualHost();
                if (this.getComponent().getDefaultHost() == vhost) {
                    this.getLogger().fine("Default virtual host selected");
                } else {
                    this.getLogger().fine("Virtual host selected: \"" + vhost.getHostScheme() + "\", \"" + vhost.getHostDomain() + "\", \"" + vhost.getHostPort() + "\"");
                }
            } else {
                super.logRoute(route);
            }
        }
    }

    @Override
    public synchronized void start() throws Exception {
        for (VirtualHost host : this.getComponent().getHosts()) {
            this.getRoutes().add(new HostRoute((Router)this, host));
        }
        if (this.getComponent().getDefaultHost() != null) {
            this.getRoutes().add(new HostRoute((Router)this, this.getComponent().getDefaultHost()));
        }
        Restlet noHostMatched = new Restlet(this.getComponent().getContext().createChildContext()){

            @Override
            public void handle(Request request, Response response) {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "No virtual host could handle the request");
            }
        };
        this.setDefaultRoute(new TemplateRoute((Router)this, "", noHostMatched));
        super.start();
    }

    @Override
    public synchronized void stop() throws Exception {
        this.getRoutes().clear();
        super.stop();
    }
}

