/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.util.ByteArrayHashKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.hadoop.hbase.util.JenkinsHash;

public final class HBCKRegionInfo {
    static final int ENC_SEPARATOR = 46;
    static final int MD5_HEX_LENGTH = 32;
    static final int DEFAULT_REPLICA_ID = 0;
    static final byte REPLICA_ID_DELIMITER = 95;

    private HBCKRegionInfo() {
    }

    public static boolean hasEncodedName(byte[] regionName) {
        return regionName.length >= 1 && regionName[regionName.length - 1] == 46;
    }

    public static String encodeRegionName(byte[] regionName) {
        String encodedName;
        if (HBCKRegionInfo.hasEncodedName(regionName)) {
            encodedName = Bytes.toString((byte[])regionName, (int)(regionName.length - 32 - 1), (int)32);
        } else {
            ByteArrayHashKey key = new ByteArrayHashKey(regionName, 0, regionName.length);
            int hashVal = Math.abs(JenkinsHash.getInstance().hash((HashKey)key, 0));
            encodedName = String.valueOf(hashVal);
        }
        return encodedName;
    }

    public static byte[][] parseRegionNameOrReturnNull(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            return null;
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        int endOffset = regionName.length;
        if (regionName.length > 34 && regionName[regionName.length - 1] == 46 && regionName[regionName.length - 32 - 2] == 46) {
            endOffset = endOffset - 32 - 2;
        }
        byte[] replicaId = null;
        int idEndOffset = endOffset;
        for (int i = endOffset - 1; i > 0; --i) {
            if (regionName[i] == 95) {
                replicaId = new byte[endOffset - i - 1];
                System.arraycopy(regionName, i + 1, replicaId, 0, endOffset - i - 1);
                idEndOffset = i;
            }
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            return null;
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[idEndOffset - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, idEndOffset - offset - 1);
        byte[][] elements = new byte[replicaId == null ? 3 : 4][];
        elements[0] = tableName;
        elements[1] = startKey;
        elements[2] = id;
        if (replicaId != null) {
            elements[3] = replicaId;
        }
        return elements;
    }
}

