/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.jruby.embed.ScriptingContainer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestShell implements RubyShellTest {
  protected final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
  protected final ScriptingContainer jruby = new ScriptingContainer();

  @Override
  public HBaseTestingUtility getTEST_UTIL() {
    return TEST_UTIL;
  }

  @Override
  public ScriptingContainer getJRuby() {
    return jruby;
  }

  @Override
  public String getSuitePattern() {
    return "**/*_test.rb";
  }

  @Before
  public void setUp() throws Exception {
    RubyShellTest.setUpConfig(this);

    // Start mini cluster
    TEST_UTIL.startMiniCluster(1);

    RubyShellTest.setUpJRubyRuntime(this);

    RubyShellTest.doTestSetup(this);
  }

  @After
  public void tearDown() throws Exception {
    TEST_UTIL.shutdownMiniCluster();
  }

  @Test
  public void testRunShellTests() throws IOException {
    RubyShellTest.testRunShellTests(this);
  }
}
