/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.scheduler.ResourceRequestSetKey;

public class ResourceRequestSet {
    private ResourceRequestSetKey key;
    private int numContainers;
    private Map<String, ResourceRequest> asks;

    public ResourceRequestSet(ResourceRequestSetKey key) throws YarnException {
        this.key = key;
        this.numContainers = 0;
        this.asks = new HashMap<String, ResourceRequest>();
    }

    public ResourceRequestSet(ResourceRequestSet other) {
        this.key = other.key;
        this.numContainers = other.numContainers;
        this.asks = new HashMap<String, ResourceRequest>();
        this.asks.putAll(other.asks);
    }

    public void addAndOverrideRR(ResourceRequest ask) throws YarnException {
        if (!this.key.equals(new ResourceRequestSetKey(ask))) {
            throw new YarnException("None compatible asks: \n" + ask + "\n" + this.key);
        }
        this.asks.put(ask.getResourceName(), ask);
        if (this.key.getExeType().equals((Object)ExecutionType.GUARANTEED)) {
            if (ask.getResourceName().equals("*")) {
                this.numContainers = ask.getNumContainers();
            }
        } else {
            this.numContainers = ask.getNumContainers();
        }
        if (this.numContainers < 0) {
            throw new YarnException("numContainers becomes " + this.numContainers + " when adding ask " + ask + "\n requestSet: " + this.toString());
        }
    }

    public void addAndOverrideRRSet(ResourceRequestSet requestSet) throws YarnException {
        if (requestSet == null) {
            return;
        }
        for (ResourceRequest rr : requestSet.getRRs()) {
            this.addAndOverrideRR(rr);
        }
    }

    public void cleanupZeroNonAnyRR() {
        Iterator<Map.Entry<String, ResourceRequest>> iter = this.asks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ResourceRequest> entry = iter.next();
            if (entry.getKey().equals("*") || entry.getValue().getNumContainers() != 0) continue;
            iter.remove();
        }
    }

    public Map<String, ResourceRequest> getAsks() {
        return this.asks;
    }

    public Collection<ResourceRequest> getRRs() {
        return this.asks.values();
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public void setNumContainers(int newValue) throws YarnException {
        if (this.numContainers == 0) {
            throw new YarnException("should not set numContainers to " + newValue + " for a cancel requestSet: " + this.toString());
        }
        int oldValue = this.numContainers;
        this.numContainers = newValue;
        if (this.key.getExeType().equals((Object)ExecutionType.OPPORTUNISTIC)) {
            HashMap<String, ResourceRequest> newAsks = new HashMap<String, ResourceRequest>();
            for (ResourceRequest rr : this.asks.values()) {
                ResourceRequest clone = ResourceRequest.clone((ResourceRequest)rr);
                clone.setNumContainers(newValue);
                newAsks.put(clone.getResourceName(), clone);
            }
            this.asks = newAsks;
        } else {
            ResourceRequest rr = this.asks.get("*");
            if (rr == null) {
                throw new YarnException("No ANY RR found in requestSet with numContainers=" + oldValue);
            }
            ResourceRequest clone = ResourceRequest.clone((ResourceRequest)rr);
            clone.setNumContainers(newValue);
            this.asks.put("*", clone);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{" + this.key.toString());
        for (Map.Entry<String, ResourceRequest> entry : this.asks.entrySet()) {
            builder.append(" " + entry.getValue().getNumContainers() + ":" + entry.getKey());
        }
        builder.append("}");
        return builder.toString();
    }
}

