/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.util.ConstEnumCounters;
import org.apache.hadoop.hdfs.util.EnumCounters;

public class QuotaCounts {
    static final EnumCounters<Quota> QUOTA_RESET = new ConstEnumCounters<Quota>(Quota.class, -1L);
    static final EnumCounters<Quota> QUOTA_DEFAULT = new ConstEnumCounters<Quota>(Quota.class, 0L);
    static final EnumCounters<StorageType> STORAGE_TYPE_RESET = new ConstEnumCounters<StorageType>(StorageType.class, -1L);
    static final EnumCounters<StorageType> STORAGE_TYPE_DEFAULT = new ConstEnumCounters<StorageType>(StorageType.class, 0L);
    @VisibleForTesting
    EnumCounters<Quota> nsSsCounts;
    @VisibleForTesting
    EnumCounters<StorageType> tsCounts;

    static <T extends Enum<T>> EnumCounters<T> modify(EnumCounters<T> counter, ModifyAction<T> action) {
        if (counter instanceof ConstEnumCounters) {
            counter = counter.deepCopyEnumCounter();
        }
        action.accept(counter);
        return counter;
    }

    private QuotaCounts(Builder builder) {
        this.nsSsCounts = builder.nsSsCounts;
        this.tsCounts = builder.tsCounts;
    }

    public QuotaCounts add(final QuotaCounts that) {
        this.nsSsCounts = QuotaCounts.modify(this.nsSsCounts, new ModifyAction<Quota>(){

            @Override
            public void accept(EnumCounters<Quota> counter) {
                counter.add(that.nsSsCounts);
            }
        });
        this.tsCounts = QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

            @Override
            public void accept(EnumCounters<StorageType> counter) {
                counter.add(that.tsCounts);
            }
        });
        return this;
    }

    public QuotaCounts subtract(final QuotaCounts that) {
        this.nsSsCounts = QuotaCounts.modify(this.nsSsCounts, new ModifyAction<Quota>(){

            @Override
            public void accept(EnumCounters<Quota> counter) {
                counter.subtract(that.nsSsCounts);
            }
        });
        this.tsCounts = QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

            @Override
            public void accept(EnumCounters<StorageType> counter) {
                counter.subtract(that.tsCounts);
            }
        });
        return this;
    }

    public QuotaCounts negation() {
        QuotaCounts ret = new Builder().quotaCount(this).build();
        ret.nsSsCounts = QuotaCounts.modify(ret.nsSsCounts, new ModifyAction<Quota>(){

            @Override
            public void accept(EnumCounters<Quota> counter) {
                counter.negation();
            }
        });
        ret.tsCounts = QuotaCounts.modify(ret.tsCounts, new ModifyAction<StorageType>(){

            @Override
            public void accept(EnumCounters<StorageType> counter) {
                counter.negation();
            }
        });
        return ret;
    }

    public long getNameSpace() {
        return this.nsSsCounts.get(Quota.NAMESPACE);
    }

    public void setNameSpace(long nameSpaceCount) {
        this.nsSsCounts = QuotaCounts.setQuotaCounter(this.nsSsCounts, Quota.NAMESPACE, Quota.STORAGESPACE, nameSpaceCount);
    }

    public void addNameSpace(final long nsDelta) {
        this.nsSsCounts = QuotaCounts.modify(this.nsSsCounts, new ModifyAction<Quota>(){

            @Override
            public void accept(EnumCounters<Quota> counter) {
                counter.add(Quota.NAMESPACE, nsDelta);
            }
        });
    }

    public long getStorageSpace() {
        return this.nsSsCounts.get(Quota.STORAGESPACE);
    }

    public void setStorageSpace(long spaceCount) {
        this.nsSsCounts = QuotaCounts.setQuotaCounter(this.nsSsCounts, Quota.STORAGESPACE, Quota.NAMESPACE, spaceCount);
    }

    public void addStorageSpace(final long dsDelta) {
        this.nsSsCounts = QuotaCounts.modify(this.nsSsCounts, new ModifyAction<Quota>(){

            @Override
            public void accept(EnumCounters<Quota> counter) {
                counter.add(Quota.STORAGESPACE, dsDelta);
            }
        });
    }

    public EnumCounters<StorageType> getTypeSpaces() {
        EnumCounters<StorageType> ret = new EnumCounters<StorageType>(StorageType.class);
        ret.set(this.tsCounts);
        return ret;
    }

    void setTypeSpaces(final EnumCounters<StorageType> that) {
        if (that == STORAGE_TYPE_DEFAULT || that == STORAGE_TYPE_RESET) {
            this.tsCounts = that;
        } else if (that != null) {
            this.tsCounts = QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

                @Override
                public void accept(EnumCounters<StorageType> counter) {
                    counter.set(that);
                }
            });
        }
    }

    long getTypeSpace(StorageType type) {
        return this.tsCounts.get(type);
    }

    void setTypeSpace(final StorageType type, final long spaceCount) {
        this.tsCounts = QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

            @Override
            public void accept(EnumCounters<StorageType> counter) {
                counter.set(type, spaceCount);
            }
        });
    }

    public void addTypeSpace(final StorageType type, final long delta) {
        this.tsCounts = QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

            @Override
            public void accept(EnumCounters<StorageType> counter) {
                counter.add(type, delta);
            }
        });
    }

    public boolean anyNsSsCountGreaterOrEqual(long val) {
        if (this.nsSsCounts == QUOTA_DEFAULT) {
            return val <= 0L;
        }
        if (this.nsSsCounts == QUOTA_RESET) {
            return val <= -1L;
        }
        return this.nsSsCounts.anyGreaterOrEqual(val);
    }

    public boolean anyTypeSpaceCountGreaterOrEqual(long val) {
        if (this.tsCounts == STORAGE_TYPE_DEFAULT) {
            return val <= 0L;
        }
        if (this.tsCounts == STORAGE_TYPE_RESET) {
            return val <= -1L;
        }
        return this.tsCounts.anyGreaterOrEqual(val);
    }

    private static EnumCounters<Quota> setQuotaCounter(EnumCounters<Quota> inputCounts, final Quota quotaToSet, Quota otherQuota, final long val) {
        if (val == -1L && inputCounts.get(otherQuota) == -1L) {
            return QUOTA_RESET;
        }
        if (val == 0L && inputCounts.get(otherQuota) == 0L) {
            return QUOTA_DEFAULT;
        }
        return QuotaCounts.modify(inputCounts, new ModifyAction<Quota>(){

            @Override
            public void accept(EnumCounters<Quota> counter) {
                counter.set(quotaToSet, val);
            }
        });
    }

    public String toString() {
        return "name space=" + this.getNameSpace() + "\nstorage space=" + this.getStorageSpace() + "\nstorage types=" + this.getTypeSpaces();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof QuotaCounts)) {
            return false;
        }
        QuotaCounts that = (QuotaCounts)obj;
        return this.nsSsCounts.equals(that.nsSsCounts) && this.tsCounts.equals(that.tsCounts);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public static class Builder {
        private EnumCounters<Quota> nsSsCounts = QUOTA_DEFAULT;
        private EnumCounters<StorageType> tsCounts = STORAGE_TYPE_DEFAULT;

        public Builder nameSpace(long val) {
            this.nsSsCounts = QuotaCounts.setQuotaCounter(this.nsSsCounts, Quota.NAMESPACE, Quota.STORAGESPACE, val);
            return this;
        }

        public Builder storageSpace(long val) {
            this.nsSsCounts = QuotaCounts.setQuotaCounter(this.nsSsCounts, Quota.STORAGESPACE, Quota.NAMESPACE, val);
            return this;
        }

        public Builder typeSpaces(final EnumCounters<StorageType> val) {
            if (val != null) {
                this.tsCounts = val == STORAGE_TYPE_DEFAULT || val == STORAGE_TYPE_RESET ? val : QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

                    @Override
                    public void accept(EnumCounters<StorageType> counter) {
                        counter.set(val);
                    }
                });
            }
            return this;
        }

        public Builder typeSpaces(final long val) {
            this.tsCounts = val == -1L ? STORAGE_TYPE_RESET : (val == 0L ? STORAGE_TYPE_DEFAULT : QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

                @Override
                public void accept(EnumCounters<StorageType> counter) {
                    counter.reset(val);
                }
            }));
            return this;
        }

        public Builder quotaCount(final QuotaCounts that) {
            this.nsSsCounts = that.nsSsCounts == QUOTA_DEFAULT || that.nsSsCounts == QUOTA_RESET ? that.nsSsCounts : QuotaCounts.modify(this.nsSsCounts, new ModifyAction<Quota>(){

                @Override
                public void accept(EnumCounters<Quota> counter) {
                    counter.set(that.nsSsCounts);
                }
            });
            this.tsCounts = that.tsCounts == STORAGE_TYPE_DEFAULT || that.tsCounts == STORAGE_TYPE_RESET ? that.tsCounts : QuotaCounts.modify(this.tsCounts, new ModifyAction<StorageType>(){

                @Override
                public void accept(EnumCounters<StorageType> counter) {
                    counter.set(that.tsCounts);
                }
            });
            return this;
        }

        public QuotaCounts build() {
            return new QuotaCounts(this);
        }
    }

    private static interface ModifyAction<T extends Enum<T>> {
        public void accept(EnumCounters<T> var1);
    }
}

