/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.RestoreRequest;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class BackupUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BackupUtils.class);
    public static final String LOGNAME_SEPARATOR = ".";
    public static final int MILLISEC_IN_HOUR = 3600000;

    private BackupUtils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static Map<String, Long> getRSLogTimestampMins(Map<TableName, Map<String, Long>> rsLogTimestampMap) {
        if (rsLogTimestampMap == null || rsLogTimestampMap.isEmpty()) {
            return null;
        }
        HashMap<String, Long> rsLogTimestampMins = new HashMap<String, Long>();
        HashMap rsLogTimestampMapByRS = new HashMap();
        for (Map.Entry<TableName, Map<String, Long>> entry : rsLogTimestampMap.entrySet()) {
            TableName table = entry.getKey();
            Map<String, Long> rsLogTimestamp = entry.getValue();
            for (Map.Entry<String, Long> rsEntry : rsLogTimestamp.entrySet()) {
                String rs = rsEntry.getKey();
                Long ts = rsEntry.getValue();
                rsLogTimestampMapByRS.putIfAbsent(rs, new HashMap());
                ((HashMap)rsLogTimestampMapByRS.get(rs)).put(table, ts);
            }
        }
        for (Map.Entry<Object, Map<String, Long>> entry : rsLogTimestampMapByRS.entrySet()) {
            String rs = (String)entry.getKey();
            rsLogTimestampMins.put(rs, BackupUtils.getMinValue(entry.getValue()));
        }
        return rsLogTimestampMins;
    }

    public static void copyTableRegionInfo(Connection conn, BackupInfo backupInfo, Configuration conf) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        try (Admin admin = conn.getAdmin();){
            for (TableName table : backupInfo.getTables()) {
                if (!admin.tableExists(table)) {
                    LOG.warn("Table " + table + " does not exists, skipping it.");
                    continue;
                }
                TableDescriptor orig = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)fs, (Path)rootDir, (TableName)table);
                Path target = new Path(backupInfo.getTableBackupDir(table));
                FileSystem targetFs = target.getFileSystem(conf);
                FSTableDescriptors descriptors = new FSTableDescriptors(targetFs, CommonFSUtils.getRootDir((Configuration)conf));
                descriptors.createTableDescriptorForTableDirectory(target, orig, false);
                LOG.debug("Attempting to copy table info for:" + table + " target: " + target + " descriptor: " + orig);
                LOG.debug("Finished copying tableinfo.");
                List regions = MetaTableAccessor.getTableRegions((Connection)conn, (TableName)table);
                LOG.debug("Starting to write region info for table " + table);
                for (RegionInfo regionInfo : regions) {
                    Path regionDir = FSUtils.getRegionDirFromTableDir((Path)new Path(backupInfo.getTableBackupDir(table)), (RegionInfo)regionInfo);
                    regionDir = new Path(backupInfo.getTableBackupDir(table), regionDir.getName());
                    BackupUtils.writeRegioninfoOnFilesystem(conf, targetFs, regionDir, regionInfo);
                }
                LOG.debug("Finished writing region info for table " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRegioninfoOnFilesystem(Configuration conf, FileSystem fs, Path regionInfoDir, RegionInfo regionInfo) throws IOException {
        byte[] content = RegionInfo.toDelimitedByteArray((RegionInfo)regionInfo);
        Path regionInfoFile = new Path(regionInfoDir, ".regioninfo");
        FsPermission perms = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)conf, (String)"hbase.data.umask");
        try (FSDataOutputStream out = FSUtils.create((Configuration)conf, (FileSystem)fs, (Path)regionInfoFile, (FsPermission)perms, null);){
            out.write(content);
        }
    }

    public static String parseHostNameFromLogFile(Path p) {
        try {
            if (AbstractFSWALProvider.isArchivedLogFile((Path)p)) {
                return BackupUtils.parseHostFromOldLog(p);
            }
            ServerName sname = AbstractFSWALProvider.getServerNameFromWALDirectoryName((Path)p);
            if (sname != null) {
                return sname.getAddress().toString();
            }
            LOG.error("Skip log file (can't parse): " + p);
            return null;
        }
        catch (Exception e) {
            LOG.error("Skip log file (can't parse): " + p, (Throwable)e);
            return null;
        }
    }

    public static String getUniqueWALFileNamePart(String walFileName) {
        return BackupUtils.getUniqueWALFileNamePart(new Path(walFileName));
    }

    public static String getUniqueWALFileNamePart(Path p) {
        return p.getName();
    }

    public static long getFilesLength(FileSystem fs, Path dir) throws IOException {
        long totalLength = 0L;
        FileStatus[] files = CommonFSUtils.listStatus((FileSystem)fs, (Path)dir);
        if (files != null) {
            for (FileStatus fileStatus : files) {
                if (fileStatus.isDirectory()) {
                    totalLength += BackupUtils.getFilesLength(fs, fileStatus.getPath());
                    continue;
                }
                totalLength += fileStatus.getLen();
            }
        }
        return totalLength;
    }

    public static List<String> getWALFilesOlderThan(Configuration c, HashMap<String, Long> hostTimestampMap) throws IOException {
        Path walRootDir = CommonFSUtils.getWALRootDir((Configuration)c);
        Path logDir = new Path(walRootDir, "WALs");
        Path oldLogDir = new Path(walRootDir, "oldWALs");
        List<String> logFiles = new ArrayList<String>();
        PathFilter filter = p -> {
            try {
                if (AbstractFSWALProvider.isMetaFile((Path)p)) {
                    return false;
                }
                String host = BackupUtils.parseHostNameFromLogFile(p);
                if (host == null) {
                    return false;
                }
                Long oldTimestamp = (Long)hostTimestampMap.get(host);
                Long currentLogTS = BackupUtils.getCreationTime(p);
                return currentLogTS <= oldTimestamp;
            }
            catch (Exception e) {
                LOG.warn("Can not parse" + p, (Throwable)e);
                return false;
            }
        };
        FileSystem walFs = CommonFSUtils.getWALFileSystem((Configuration)c);
        logFiles = BackupUtils.getFiles(walFs, logDir, logFiles, filter);
        logFiles = BackupUtils.getFiles(walFs, oldLogDir, logFiles, filter);
        return logFiles;
    }

    public static TableName[] parseTableNames(String tables) {
        if (tables == null) {
            return null;
        }
        return (TableName[])Splitter.on((String)",").splitToStream((CharSequence)tables).map(TableName::valueOf).toArray(TableName[]::new);
    }

    public static boolean checkPathExist(String backupStr, Configuration conf) throws IOException {
        boolean isExist = false;
        Path backupPath = new Path(backupStr);
        FileSystem fileSys = backupPath.getFileSystem(conf);
        String targetFsScheme = fileSys.getUri().getScheme();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Schema of given url: " + backupStr + " is: " + targetFsScheme);
        }
        if (fileSys.exists(backupPath)) {
            isExist = true;
        }
        return isExist;
    }

    public static void checkTargetDir(String backupRootPath, Configuration conf) throws IOException {
        boolean targetExists;
        try {
            targetExists = BackupUtils.checkPathExist(backupRootPath, conf);
        }
        catch (IOException e) {
            String expMsg = e.getMessage();
            String newMsg = null;
            if (expMsg.contains("No FileSystem for scheme")) {
                newMsg = "Unsupported filesystem scheme found in the backup target url. Error Message: " + expMsg;
                LOG.error(newMsg);
                throw new IOException(newMsg);
            }
            throw e;
        }
        if (targetExists) {
            LOG.info("Using existing backup root dir: " + backupRootPath);
        } else {
            LOG.info("Backup root dir " + backupRootPath + " does not exist. Will be created.");
        }
    }

    public static <T> Long getMinValue(Map<T, Long> map) {
        Long minTimestamp = null;
        if (map != null) {
            ArrayList<Long> timestampList = new ArrayList<Long>(map.values());
            Collections.sort(timestampList);
            minTimestamp = timestampList.get(0);
        }
        return minTimestamp;
    }

    public static String parseHostFromOldLog(Path p) {
        if (p.getName().endsWith("$masterlocalwal$")) {
            return null;
        }
        try {
            String urlDecodedName = URLDecoder.decode(p.getName(), "UTF8");
            Iterable nameSplitsOnComma = Splitter.on((String)",").split((CharSequence)urlDecodedName);
            String host = (String)Iterables.get((Iterable)nameSplitsOnComma, (int)0);
            String port = (String)Iterables.get((Iterable)nameSplitsOnComma, (int)1);
            return host + ":" + port;
        }
        catch (Exception e) {
            LOG.warn("Skip log file (can't parse): {}", (Object)p);
            return null;
        }
    }

    public static Long getCreationTime(Path p) throws IOException {
        int idx = p.getName().lastIndexOf(LOGNAME_SEPARATOR);
        if (idx < 0) {
            throw new IOException("Cannot parse timestamp from path " + p);
        }
        String ts = p.getName().substring(idx + 1);
        return Long.parseLong(ts);
    }

    public static List<String> getFiles(FileSystem fs, Path rootDir, List<String> files, PathFilter filter) throws IOException {
        RemoteIterator it = fs.listFiles(rootDir, true);
        while (it.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)it.next();
            if (lfs.isDirectory() || !filter.accept(lfs.getPath())) continue;
            files.add(lfs.getPath().toString());
        }
        return files;
    }

    public static void cleanupBackupData(BackupInfo context, Configuration conf) throws IOException {
        BackupUtils.cleanupHLogDir(context, conf);
        BackupUtils.cleanupTargetDir(context, conf);
    }

    private static void cleanupHLogDir(BackupInfo backupInfo, Configuration conf) throws IOException {
        String logDir = backupInfo.getHLogTargetDir();
        if (logDir == null) {
            LOG.warn("No log directory specified for " + backupInfo.getBackupId());
            return;
        }
        Path rootPath = new Path(logDir).getParent();
        FileSystem fs = FileSystem.get((URI)rootPath.toUri(), (Configuration)conf);
        FileStatus[] files = BackupUtils.listStatus(fs, rootPath, null);
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            LOG.debug("Delete log files: " + file.getPath().getName());
            fs.delete(file.getPath(), true);
        }
    }

    private static void cleanupTargetDir(BackupInfo backupInfo, Configuration conf) {
        try {
            LOG.debug("Trying to cleanup up target dir : " + backupInfo.getBackupId());
            String targetDir = backupInfo.getBackupRootDir();
            if (targetDir == null) {
                LOG.warn("No target directory specified for " + backupInfo.getBackupId());
                return;
            }
            FileSystem outputFs = FileSystem.get((URI)new Path(backupInfo.getBackupRootDir()).toUri(), (Configuration)conf);
            for (TableName table : backupInfo.getTables()) {
                Path tableDir;
                FileStatus[] backups;
                Path targetDirPath = new Path(BackupUtils.getTableBackupDir(backupInfo.getBackupRootDir(), backupInfo.getBackupId(), table));
                if (outputFs.delete(targetDirPath, true)) {
                    LOG.info("Cleaning up backup data at " + targetDirPath.toString() + " done.");
                } else {
                    LOG.info("No data has been found in " + targetDirPath.toString() + LOGNAME_SEPARATOR);
                }
                if ((backups = BackupUtils.listStatus(outputFs, tableDir = targetDirPath.getParent(), null)) != null && backups.length != 0) continue;
                outputFs.delete(tableDir, true);
                LOG.debug(tableDir.toString() + " is empty, remove it.");
            }
            outputFs.delete(new Path(targetDir, backupInfo.getBackupId()), true);
        }
        catch (IOException e1) {
            LOG.error("Cleaning up backup data of " + backupInfo.getBackupId() + " at " + backupInfo.getBackupRootDir() + " failed due to " + e1.getMessage() + LOGNAME_SEPARATOR);
        }
    }

    public static String getTableBackupDir(String backupRootDir, String backupId, TableName tableName) {
        return backupRootDir + "/" + backupId + "/" + tableName.getNamespaceAsString() + "/" + tableName.getQualifierAsString() + "/";
    }

    public static ArrayList<BackupInfo> sortHistoryListDesc(ArrayList<BackupInfo> historyList) {
        ArrayList<BackupInfo> list = new ArrayList<BackupInfo>();
        TreeMap<String, BackupInfo> map = new TreeMap<String, BackupInfo>();
        for (BackupInfo h : historyList) {
            map.put(Long.toString(h.getStartTs()), h);
        }
        Iterator i = map.descendingKeySet().iterator();
        while (i.hasNext()) {
            list.add((BackupInfo)map.get(i.next()));
        }
        return list;
    }

    public static FileStatus[] listStatus(FileSystem fs, Path dir, PathFilter filter) throws IOException {
        FileStatus[] status;
        block3: {
            status = null;
            try {
                status = filter == null ? fs.listStatus(dir) : fs.listStatus(dir, filter);
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace(dir + " doesn't exist");
            }
        }
        if (status == null || status.length < 1) {
            return null;
        }
        return status;
    }

    public static String getPath(Path p) {
        return p.toUri().getPath();
    }

    public static String getLogBackupDir(String backupRootDir, String backupId) {
        return backupRootDir + "/" + backupId + "/" + "WALs";
    }

    private static List<BackupInfo> getHistory(Configuration conf, Path backupRootPath) throws IOException {
        FileSystem fs = FileSystem.get((URI)backupRootPath.toUri(), (Configuration)conf);
        RemoteIterator it = fs.listLocatedStatus(backupRootPath);
        ArrayList<BackupInfo> infos = new ArrayList<BackupInfo>();
        while (it.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)it.next();
            if (!lfs.isDirectory()) continue;
            String backupId = lfs.getPath().getName();
            try {
                BackupInfo info = BackupUtils.loadBackupInfo(backupRootPath, backupId, fs);
                infos.add(info);
            }
            catch (IOException e) {
                LOG.error("Can not load backup info from: " + lfs.getPath(), (Throwable)e);
            }
        }
        Collections.sort(infos, new Comparator<BackupInfo>(){

            @Override
            public int compare(BackupInfo o1, BackupInfo o2) {
                long ts2;
                long ts1 = this.getTimestamp(o1.getBackupId());
                if (ts1 == (ts2 = this.getTimestamp(o2.getBackupId()))) {
                    return 0;
                }
                return ts1 < ts2 ? 1 : -1;
            }

            private long getTimestamp(String backupId) {
                return Long.parseLong((String)Iterators.get(Splitter.on((char)'_').split((CharSequence)backupId).iterator(), (int)1));
            }
        });
        return infos;
    }

    public static List<BackupInfo> getHistory(Configuration conf, int n, Path backupRootPath, BackupInfo.Filter ... filters) throws IOException {
        List<BackupInfo> infos = BackupUtils.getHistory(conf, backupRootPath);
        ArrayList<BackupInfo> ret = new ArrayList<BackupInfo>();
        for (BackupInfo info : infos) {
            if (ret.size() == n) break;
            boolean passed = true;
            for (int i = 0; i < filters.length; ++i) {
                if (filters[i].apply(info)) continue;
                passed = false;
                break;
            }
            if (!passed) continue;
            ret.add(info);
        }
        return ret;
    }

    public static BackupInfo loadBackupInfo(Path backupRootPath, String backupId, FileSystem fs) throws IOException {
        Path backupPath = new Path(backupRootPath, backupId);
        RemoteIterator it = fs.listFiles(backupPath, true);
        while (it.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)it.next();
            if (!lfs.getPath().getName().equals(".backup.manifest")) continue;
            BackupManifest manifest = new BackupManifest(fs, lfs.getPath().getParent());
            BackupInfo info = manifest.toBackupInfo();
            return info;
        }
        return null;
    }

    public static RestoreRequest createRestoreRequest(String backupRootDir, String backupId, boolean check, TableName[] fromTables, TableName[] toTables, boolean isOverwrite) {
        return BackupUtils.createRestoreRequest(backupRootDir, backupId, check, fromTables, toTables, isOverwrite, false);
    }

    public static RestoreRequest createRestoreRequest(String backupRootDir, String backupId, boolean check, TableName[] fromTables, TableName[] toTables, boolean isOverwrite, boolean isKeepOriginalSplits) {
        RestoreRequest.Builder builder = new RestoreRequest.Builder();
        RestoreRequest request = builder.withBackupRootDir(backupRootDir).withBackupId(backupId).withCheck(check).withFromTables(fromTables).withToTables(toTables).withOvewrite(isOverwrite).withKeepOriginalSplits(isKeepOriginalSplits).build();
        return request;
    }

    public static boolean validate(List<TableName> tables, BackupManifest backupManifest, Configuration conf) throws IOException {
        boolean isValid = true;
        block0: for (TableName table : tables) {
            TreeSet<BackupManifest.BackupImage> imageSet = new TreeSet<BackupManifest.BackupImage>();
            ArrayList<BackupManifest.BackupImage> depList = backupManifest.getDependentListByTable(table);
            if (depList != null && !depList.isEmpty()) {
                imageSet.addAll(depList);
            }
            LOG.info("Dependent image(s) from old to new:");
            for (BackupManifest.BackupImage image : imageSet) {
                String imageDir = HBackupFileSystem.getTableBackupDir(image.getRootDir(), image.getBackupId(), table);
                if (!BackupUtils.checkPathExist(imageDir, conf)) {
                    LOG.error("ERROR: backup image does not exist: " + imageDir);
                    isValid = false;
                    continue block0;
                }
                LOG.info("Backup image: " + image.getBackupId() + " for '" + table + "' is available");
            }
        }
        return isValid;
    }

    public static Path getBulkOutputDir(Path restoreRootDir, String tableName, Configuration conf, boolean deleteOnExit) throws IOException {
        FileSystem fs = restoreRootDir.getFileSystem(conf);
        Path path = new Path(restoreRootDir, "bulk_output-" + tableName + "-" + EnvironmentEdgeManager.currentTime());
        if (deleteOnExit) {
            fs.deleteOnExit(path);
        }
        return path;
    }

    public static Path getBulkOutputDir(Path restoreRootDir, String tableName, Configuration conf) throws IOException {
        return BackupUtils.getBulkOutputDir(restoreRootDir, tableName, conf, true);
    }

    public static Path getBulkOutputDir(String tableName, Configuration conf, boolean deleteOnExit) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return BackupUtils.getBulkOutputDir(BackupUtils.getTmpRestoreOutputDir(fs, conf), tableName, conf, deleteOnExit);
    }

    public static Path getTmpRestoreOutputDir(FileSystem fs, Configuration conf) {
        String tmp = conf.get("hbase.fs.tmp.dir", fs.getHomeDirectory() + "/hbase-staging");
        return new Path(tmp);
    }

    public static String getFileNameCompatibleString(TableName table) {
        return table.getNamespaceAsString() + "-" + table.getQualifierAsString();
    }

    public static boolean failed(int result) {
        return result != 0;
    }

    public static boolean succeeded(int result) {
        return result == 0;
    }

    public static BulkLoadHFiles createLoader(Configuration config) {
        Configuration conf = new Configuration(config);
        conf.setInt("hbase.rpc.timeout", 3600000);
        conf.setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", Integer.MAX_VALUE);
        conf.set("ignore.unmatched.families", "yes");
        return BulkLoadHFiles.create((Configuration)conf);
    }

    public static String findMostRecentBackupId(String[] backupIds) {
        long recentTimestamp = Long.MIN_VALUE;
        for (String backupId : backupIds) {
            long ts = Long.parseLong((String)Iterators.get(Splitter.on((char)'_').split((CharSequence)backupId).iterator(), (int)1));
            if (ts <= recentTimestamp) continue;
            recentTimestamp = ts;
        }
        return "backup_" + recentTimestamp;
    }
}

