/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NamedQueueServiceChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(NamedQueueServiceChore.class);
    public static final String NAMED_QUEUE_CHORE_DURATION_KEY = "hbase.regionserver.named.queue.chore.duration";
    public static final int NAMED_QUEUE_CHORE_DURATION_DEFAULT = 600000;
    private final NamedQueueRecorder namedQueueRecorder;
    private final Connection connection;

    public NamedQueueServiceChore(Stoppable stopper, int period, NamedQueueRecorder namedQueueRecorder, Connection connection) {
        super("NamedQueueServiceChore", stopper, period);
        this.namedQueueRecorder = namedQueueRecorder;
        this.connection = connection;
    }

    @Override
    protected void chore() {
        for (NamedQueuePayload.NamedQueueEvent event : NamedQueuePayload.NamedQueueEvent.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Starting chore for event %s", event.name()));
            }
            this.namedQueueRecorder.persistAll(event, this.connection);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(String.format("Stopping chore for event %s", event.name()));
        }
    }
}

