/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class PutCombiner<K>
extends Reducer<K, Put, K, Put> {
    private static final Logger LOG = LoggerFactory.getLogger(PutCombiner.class);

    protected void reduce(K row, Iterable<Put> vals, Reducer.Context context) throws IOException, InterruptedException {
        long threshold = context.getConfiguration().getLong("putcombiner.row.threshold", 0x40000000L);
        int cnt = 0;
        long curSize = 0L;
        Put put = null;
        NavigableMap<byte[], List<Cell>> familyMap = null;
        for (Put p : vals) {
            ++cnt;
            if (put == null) {
                put = p;
                familyMap = put.getFamilyCellMap();
                continue;
            }
            for (Map.Entry entry : p.getFamilyCellMap().entrySet()) {
                List cells = (List)familyMap.get(entry.getKey());
                List kvs = cells != null ? cells : null;
                for (Cell cell : (List)entry.getValue()) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                    curSize += kv.heapSize();
                    if (kvs == null) continue;
                    kvs.add(kv);
                }
                if (cells != null) continue;
                familyMap.put((byte[])entry.getKey(), (List<Cell>)entry.getValue());
            }
            if (cnt % 10 == 0) {
                context.setStatus("Combine " + cnt);
            }
            if (curSize <= threshold) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Combined %d Put(s) into %d.", cnt, 1));
            }
            context.write(row, (Object)put);
            put = null;
            curSize = 0L;
            cnt = 0;
        }
        if (put != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Combined %d Put(s) into %d.", cnt, 1));
            }
            context.write(row, (Object)put);
        }
    }
}

