/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.util.Objects;
import org.apache.hadoop.hbase.io.crypto.tls.BCFKSFileLoader;
import org.apache.hadoop.hbase.io.crypto.tls.FileKeyStoreLoader;
import org.apache.hadoop.hbase.io.crypto.tls.JKSFileLoader;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.PEMFileLoader;
import org.apache.hadoop.hbase.io.crypto.tls.PKCS12FileLoader;

final class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type) {
        switch (Objects.requireNonNull(type)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
            case PKCS12: {
                return new PKCS12FileLoader.Builder();
            }
            case BCFKS: {
                return new BCFKSFileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type.name()));
    }

    private FileKeyStoreLoaderBuilderProvider() {
    }
}

