/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509Util;
import org.apache.hadoop.hbase.security.AbstractTestMutualTls;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestMutualTlsServerSide
extends AbstractTestMutualTls {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMutualTlsServerSide.class);
    @Parameterized.Parameter(value=6)
    public X509Util.ClientAuth clientAuthMode;

    @Parameterized.Parameters(name="{index}: caKeyType={0}, certKeyType={1}, keyPassword={2}, validateClientHostnames={3}, testCase={4}, clientAuthMode={5}")
    public static List<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (String keyPassword : new String[]{"", "pa$$w0rd"}) {
                    Boolean[] booleanArray = new Boolean[]{true, false};
                    int n = booleanArray.length;
                    for (int i = 0; i < n; ++i) {
                        boolean validateClientHostnames = booleanArray[i];
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, validateClientHostnames, AbstractTestMutualTls.CertConfig.NO_CLIENT_CERT, X509Util.ClientAuth.NONE});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, validateClientHostnames, AbstractTestMutualTls.CertConfig.NON_VERIFIABLE_CERT, X509Util.ClientAuth.NONE});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, validateClientHostnames, AbstractTestMutualTls.CertConfig.VERIFIABLE_CERT_WITH_BAD_HOST, X509Util.ClientAuth.NONE});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, validateClientHostnames, AbstractTestMutualTls.CertConfig.NO_CLIENT_CERT, X509Util.ClientAuth.WANT});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, false, validateClientHostnames, AbstractTestMutualTls.CertConfig.NON_VERIFIABLE_CERT, X509Util.ClientAuth.WANT});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, !validateClientHostnames, validateClientHostnames, AbstractTestMutualTls.CertConfig.VERIFIABLE_CERT_WITH_BAD_HOST, X509Util.ClientAuth.WANT});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, false, validateClientHostnames, AbstractTestMutualTls.CertConfig.NO_CLIENT_CERT, X509Util.ClientAuth.NEED});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, false, validateClientHostnames, AbstractTestMutualTls.CertConfig.NON_VERIFIABLE_CERT, X509Util.ClientAuth.NEED});
                        params.add(new Object[]{caKeyType, certKeyType, keyPassword, !validateClientHostnames, validateClientHostnames, AbstractTestMutualTls.CertConfig.VERIFIABLE_CERT_WITH_BAD_HOST, X509Util.ClientAuth.NEED});
                        for (X509Util.ClientAuth mode : X509Util.ClientAuth.values()) {
                            params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, validateClientHostnames, AbstractTestMutualTls.CertConfig.GOOD_CERT, mode});
                        }
                    }
                }
            }
        }
        return params;
    }

    @Override
    protected void initialize(Configuration serverConf, Configuration clientConf) throws IOException, GeneralSecurityException, OperatorCreationException {
        serverConf.set("hbase.server.netty.tls.client.auth.mode", this.clientAuthMode.name());
        serverConf.setBoolean("hbase.server.netty.tls.verify.client.hostname", this.validateHostnames);
        this.handleCertConfig(clientConf);
    }
}

