/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMemStoreFlusher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemStoreFlusher.class);
    @Rule
    public TestName name = new TestName();
    public MemStoreFlusher msf;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.hstore.flusher.count", "0");
        this.msf = new MemStoreFlusher(conf, null);
    }

    @Test
    public void testReplaceDelayedFlushEntry() {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setRegionId(1L).setReplicaId(0).build();
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)r)).getRegionInfo();
        this.msf.requestDelayedFlush(r, 30000L);
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertTrue((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
        Assert.assertTrue((boolean)this.msf.requestFlush(r, FlushLifeCycleTracker.DUMMY));
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertFalse((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
    }

    @Test
    public void testNotReplaceDelayedFlushEntryWhichExpired() {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setRegionId(1L).setReplicaId(0).build();
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)r)).getRegionInfo();
        this.msf.requestDelayedFlush(r, 100L);
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertTrue((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
        Threads.sleep((long)200L);
        Assert.assertFalse((boolean)this.msf.requestFlush(r, FlushLifeCycleTracker.DUMMY));
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertTrue((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
    }

    @Test
    public void testChangeFlusherCount() {
        Configuration conf = new Configuration();
        conf.set("hbase.hstore.flusher.count", "0");
        HRegionServer rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        ((HRegionServer)Mockito.doReturn((Object)false).when((Object)rs)).isStopped();
        ((HRegionServer)Mockito.doReturn((Object)new RegionServerAccounting(conf)).when((Object)rs)).getRegionServerAccounting();
        this.msf = new MemStoreFlusher(conf, rs);
        this.msf.start(Threads.LOGGING_EXCEPTION_HANDLER);
        Configuration newConf = new Configuration();
        newConf.set("hbase.hstore.flusher.count", "3");
        this.msf.onConfigurationChange(newConf);
        Assert.assertEquals((long)3L, (long)this.msf.getFlusherCount());
        newConf.set("hbase.hstore.flusher.count", "0");
        this.msf.onConfigurationChange(newConf);
        Assert.assertEquals((long)1L, (long)this.msf.getFlusherCount());
    }
}

