/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.master.procedure.TruncateRegionProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTruncateRegionProcedureWithRecovery
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTruncateRegionProcedureWithRecovery.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTruncateRegionProcedureWithRecovery.class);
    @Rule
    public TestName name = new TestName();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setLong(HConstants.MAJOR_COMPACTION_PERIOD, 0L);
        conf.setBoolean("hbase.snapshot.before.destructive.action.enabled", true);
        conf.setInt("hbase.client.sync.wait.timeout.msec", 60000);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestTruncateRegionProcedureWithRecovery.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Override
    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (TableDescriptor htd : UTIL.getAdmin().listTableDescriptors()) {
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testRecoverySnapshotRollback() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String[] families = new String[]{"f1", "f2"};
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"30"), Bytes.toBytes((String)"60")};
        MasterProcedureTestingUtility.createTable(procExec, tableName, splitKeys, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 20, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 31, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 61, families);
        MasterProcedureEnv environment = (MasterProcedureEnv)procExec.getEnvironment();
        RegionInfo regionToTruncate = environment.getAssignmentManager().getAssignedRegions().stream().filter(r -> tableName.getNameAsString().equals(r.getTable().getNameAsString())).min((o1, o2) -> Bytes.compareTo((byte[])o1.getStartKey(), (byte[])o2.getStartKey())).get();
        long procId = procExec.submitProcedure((Procedure)new FailingTruncateRegionProcedure(environment, regionToTruncate));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((String)"Procedure should have failed", (boolean)result.isFailed());
        boolean snapshotFound = false;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            snapshotFound = true;
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should have been cleaned up during rollback", (!snapshotFound ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverySnapshotAndRestore() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName restoredTableName = TableName.valueOf((String)(this.name.getMethodName() + "_restored"));
        String[] families = new String[]{"f1", "f2"};
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"30"), Bytes.toBytes((String)"60")};
        MasterProcedureTestingUtility.createTable(procExec, tableName, splitKeys, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 20, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 31, families);
        AssignmentTestingUtil.insertData(UTIL, tableName, 2, 61, families);
        int initialRowCount = UTIL.countRows(tableName);
        MasterProcedureEnv environment = (MasterProcedureEnv)procExec.getEnvironment();
        RegionInfo regionToTruncate = environment.getAssignmentManager().getAssignedRegions().stream().filter(r -> tableName.getNameAsString().equals(r.getTable().getNameAsString())).min((o1, o2) -> Bytes.compareTo((byte[])o1.getStartKey(), (byte[])o2.getStartKey())).get();
        long procId = procExec.submitProcedure((Procedure)new TruncateRegionProcedure(environment, regionToTruncate));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        int rowsAfterTruncate = UTIL.countRows(tableName);
        Assert.assertTrue((String)"Should have fewer rows after truncate", (rowsAfterTruncate < initialRowCount ? 1 : 0) != 0);
        String recoverySnapshotName = null;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            recoverySnapshotName = snapshot.getName();
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should exist", (recoverySnapshotName != null ? 1 : 0) != 0);
        UTIL.getAdmin().cloneSnapshot(recoverySnapshotName, restoredTableName);
        UTIL.waitUntilAllRegionsAssigned(restoredTableName);
        Assert.assertEquals((String)"Restored table should have original data", (long)initialRowCount, (long)UTIL.countRows(restoredTableName));
        UTIL.getAdmin().disableTable(restoredTableName);
        UTIL.getAdmin().deleteTable(restoredTableName);
    }

    public static class FailingTruncateRegionProcedure
    extends TruncateRegionProcedure {
        private boolean failOnce = false;

        public FailingTruncateRegionProcedure() {
        }

        public FailingTruncateRegionProcedure(MasterProcedureEnv env, RegionInfo region) throws HBaseIOException {
            super(env, region);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.TruncateRegionState state) throws InterruptedException {
            if (!this.failOnce && state == MasterProcedureProtos.TruncateRegionState.TRUNCATE_REGION_MAKE_OFFLINE) {
                this.failOnce = true;
                throw new RuntimeException("Simulated failure");
            }
            return super.executeFromState(env, state);
        }
    }
}

