/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.ipc.TestSimpleRpcServer;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, MediumTests.class})
public class TestSecureSimpleRpcServer
extends TestSimpleRpcServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureSimpleRpcServer.class);
    private static File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;
    private static UserGroupInformation UGI;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void setupClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        String principalName = PRINCIPAL + "@" + KDC.getRealm();
        HBaseKerberosUtils.setPrincipalForTesting((String)principalName);
        Configuration conf = TEST_UTIL.getConfiguration();
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf, (String)principalName, (String)principalName);
        UGI = TestSecureSimpleRpcServer.login(KEYTAB_FILE.toString(), principalName);
        TestSimpleRpcServer.setupClass();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (KDC != null) {
            KDC.stop();
        }
        KEYTAB_FILE.delete();
        TestSimpleRpcServer.tearDownClass();
        TEST_UTIL.cleanupTestDir();
    }

    @Override
    @Test
    public void testSimpleRpcServer() throws Exception {
        UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestSecureSimpleRpcServer.this.doTest(TestSecureSimpleRpcServer.this.name.getTableName());
                return null;
            }
        });
    }

    static UserGroupInformation login(String krbKeytab, String krbPrincipal) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        return UserGroupInformation.getLoginUser();
    }

    static {
        HOST = "localhost";
    }
}

