/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTagRewriteCell {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTagRewriteCell.class);

    @Test
    public void testHeapSize() {
        Cell trCell2;
        Cell originalCell = CellUtil.createCell((byte[])Bytes.toBytes((String)"row"), (byte[])Bytes.toBytes((String)"value"));
        int fakeTagArrayLength = 10;
        Cell trCell = PrivateCellUtil.createCell((Cell)originalCell, (byte[])new byte[10]);
        long trCellHeapSize = trCell.heapSize();
        Assert.assertTrue((String)"TagRewriteCell containing a TagRewriteCell's heapsize should be larger than a single TagRewriteCell's heapsize", (trCellHeapSize < (trCell2 = PrivateCellUtil.createCell((Cell)trCell, (byte[])new byte[10])).heapSize() ? 1 : 0) != 0);
        Assert.assertTrue((String)"TagRewriteCell should have had nulled out tags array", (trCell.heapSize() < trCellHeapSize ? 1 : 0) != 0);
    }
}

