/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestVisibilityLablesWithGroups {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVisibilityLablesWithGroups.class);
    public static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW_1 = Bytes.toBytes((String)"row1");
    private static final byte[] CF = Bytes.toBytes((String)"f");
    private static final byte[] Q1 = Bytes.toBytes((String)"q1");
    private static final byte[] Q2 = Bytes.toBytes((String)"q2");
    private static final byte[] Q3 = Bytes.toBytes((String)"q3");
    private static final byte[] value1 = Bytes.toBytes((String)"value1");
    private static final byte[] value2 = Bytes.toBytes((String)"value2");
    private static final byte[] value3 = Bytes.toBytes((String)"value3");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;
    public static User TESTUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.set("hbase.superuser", "@supergroup");
        TEST_UTIL.startMiniCluster(1);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        TESTUSER = User.createUserForTesting((Configuration)conf, (String)"test", (String[])new String[]{"testgroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.addLabels((Connection)conn, (String[])new String[]{TestVisibilityLablesWithGroups.SECRET, TestVisibilityLablesWithGroups.CONFIDENTIAL});
                    VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestVisibilityLablesWithGroups.CONFIDENTIAL}, (String)"@testgroup");
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        });
    }

    @Test
    public void testGroupAuths() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        TEST_UTIL.createTable(tableName, CF);
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = connection.getTable(tableName);){
                    Put put = new Put(ROW_1);
                    put.addColumn(CF, Q1, Long.MAX_VALUE, value1);
                    put.setCellVisibility(new CellVisibility(TestVisibilityLablesWithGroups.SECRET));
                    table.put(put);
                    put = new Put(ROW_1);
                    put.addColumn(CF, Q2, Long.MAX_VALUE, value2);
                    put.setCellVisibility(new CellVisibility(TestVisibilityLablesWithGroups.CONFIDENTIAL));
                    table.put(put);
                    put = new Put(ROW_1);
                    put.addColumn(CF, Q3, Long.MAX_VALUE, value3);
                    table.put(put);
                }
                return null;
            }
        });
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = connection.getTable(tableName);){
                    Scan s = new Scan();
                    ResultScanner scanner = table.getScanner(s);
                    Result[] next = scanner.next(1);
                    Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner = next[0].cellScanner();
                    cellScanner.advance();
                    Cell current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])Q1, (int)0, (int)Q1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getValueArray(), (int)current.getValueOffset(), (int)current.getValueLength(), (byte[])value1, (int)0, (int)value1.length));
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])Q2, (int)0, (int)Q2.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getValueArray(), (int)current.getValueOffset(), (int)current.getValueLength(), (byte[])value2, (int)0, (int)value2.length));
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])Q3, (int)0, (int)Q3.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getValueArray(), (int)current.getValueOffset(), (int)current.getValueLength(), (byte[])value3, (int)0, (int)value3.length));
                }
                return null;
            }
        });
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                    Object object = null;
                    try {
                        authsResponse = VisibilityClient.getAuths((Connection)conn, (String)"@testgroup");
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (conn != null) {
                            if (object != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>(authsResponse.getAuthList().size());
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString((byte[])authBS.toByteArray()));
                }
                Assert.assertEquals((long)1L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLablesWithGroups.CONFIDENTIAL));
                return null;
            }
        });
        TESTUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = connection.getTable(tableName);){
                    Scan s = new Scan();
                    ResultScanner scanner = table.getScanner(s);
                    Result[] next = scanner.next(1);
                    Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner = next[0].cellScanner();
                    cellScanner.advance();
                    Cell current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])Q2, (int)0, (int)Q2.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getValueArray(), (int)current.getValueOffset(), (int)current.getValueLength(), (byte[])value2, (int)0, (int)value2.length));
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])Q3, (int)0, (int)Q3.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current.getValueArray(), (int)current.getValueOffset(), (int)current.getValueLength(), (byte[])value3, (int)0, (int)value3.length));
                    Scan s1 = new Scan();
                    s1.setAuthorizations(new Authorizations(new String[]{TestVisibilityLablesWithGroups.SECRET, TestVisibilityLablesWithGroups.CONFIDENTIAL}));
                    ResultScanner scanner1 = table.getScanner(s1);
                    Result[] next1 = scanner1.next(1);
                    Assert.assertTrue((next1.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner1 = next1[0].cellScanner();
                    cellScanner1.advance();
                    Cell current1 = cellScanner1.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getRowArray(), (int)current1.getRowOffset(), (int)current1.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getQualifierArray(), (int)current1.getQualifierOffset(), (int)current1.getQualifierLength(), (byte[])Q2, (int)0, (int)Q2.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getValueArray(), (int)current1.getValueOffset(), (int)current1.getValueLength(), (byte[])value2, (int)0, (int)value2.length));
                    cellScanner1.advance();
                    current1 = cellScanner1.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getRowArray(), (int)current1.getRowOffset(), (int)current1.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getQualifierArray(), (int)current1.getQualifierOffset(), (int)current1.getQualifierLength(), (byte[])Q3, (int)0, (int)Q3.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getValueArray(), (int)current1.getValueOffset(), (int)current1.getValueLength(), (byte[])value3, (int)0, (int)value3.length));
                    Scan s2 = new Scan();
                    s2.setAuthorizations(new Authorizations(new String[]{TestVisibilityLablesWithGroups.SECRET}));
                    ResultScanner scanner2 = table.getScanner(s2);
                    Result next2 = scanner2.next();
                    CellScanner cellScanner2 = next2.cellScanner();
                    cellScanner2.advance();
                    Cell current2 = cellScanner2.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current2.getRowArray(), (int)current2.getRowOffset(), (int)current2.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current2.getQualifierArray(), (int)current2.getQualifierOffset(), (int)current2.getQualifierLength(), (byte[])Q3, (int)0, (int)Q3.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current2.getValueArray(), (int)current2.getValueOffset(), (int)current2.getValueLength(), (byte[])value3, (int)0, (int)value3.length));
                    Assert.assertFalse((boolean)cellScanner2.advance());
                }
                return null;
            }
        });
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.VisibilityLabelsResponse response = null;
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    response = VisibilityClient.clearAuths((Connection)conn, (String[])new String[]{TestVisibilityLablesWithGroups.CONFIDENTIAL}, (String)"@testgroup");
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                    Object object = null;
                    try {
                        authsResponse = VisibilityClient.getAuths((Connection)conn, (String)"@testgroup");
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (conn != null) {
                            if (object != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>(authsResponse.getAuthList().size());
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString((byte[])authBS.toByteArray()));
                }
                Assert.assertEquals((long)0L, (long)authsList.size());
                return null;
            }
        });
        TESTUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = connection.getTable(tableName);){
                    Scan s1 = new Scan();
                    s1.setAuthorizations(new Authorizations(new String[]{TestVisibilityLablesWithGroups.SECRET, TestVisibilityLablesWithGroups.CONFIDENTIAL}));
                    ResultScanner scanner1 = table.getScanner(s1);
                    Result[] next1 = scanner1.next(1);
                    Assert.assertTrue((next1.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner1 = next1[0].cellScanner();
                    cellScanner1.advance();
                    Cell current1 = cellScanner1.current();
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getRowArray(), (int)current1.getRowOffset(), (int)current1.getRowLength(), (byte[])ROW_1, (int)0, (int)ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getQualifierArray(), (int)current1.getQualifierOffset(), (int)current1.getQualifierLength(), (byte[])Q3, (int)0, (int)Q3.length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])current1.getValueArray(), (int)current1.getValueOffset(), (int)current1.getValueLength(), (byte[])value3, (int)0, (int)value3.length));
                    Assert.assertFalse((boolean)cellScanner1.advance());
                }
                return null;
            }
        });
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

