/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SecureTestUtil.class);
    private static final int WAIT_TIME = 10000;

    public static void configureSuperuser(Configuration conf) throws IOException {
        String currentUser = User.getCurrent().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("admin,");
        sb.append(currentUser);
        for (int i = 0; i < 5; ++i) {
            sb.append(',');
            sb.append(currentUser);
            sb.append(".hfs.");
            sb.append(i);
        }
        sb.append(',').append("@supergroup");
        conf.set("hbase.superuser", sb.toString());
        conf.set("hbase.group.service.for.test.only", "true");
    }

    public static void enableSecurity(Configuration conf) throws IOException {
        conf.set("hadoop.security.authorization", "false");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName() + "," + MasterSyncObserver.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", AccessController.class.getName());
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.security.authorization", "true");
        SecureTestUtil.configureSuperuser(conf);
    }

    public static void verifyConfiguration(Configuration conf) {
        String coprocs = conf.get("hbase.coprocessor.region.classes");
        boolean accessControllerLoaded = false;
        for (String coproc : coprocs.split(",")) {
            try {
                accessControllerLoaded = AccessController.class.isAssignableFrom(Class.forName(coproc));
                if (!accessControllerLoaded) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!(conf.get("hbase.coprocessor.master.classes").contains(AccessController.class.getName()) && accessControllerLoaded && conf.get("hbase.coprocessor.regionserver.classes").contains(AccessController.class.getName()))) {
            throw new RuntimeException("AccessController is missing from a system coprocessor list");
        }
        if (conf.getInt("hfile.format.version", 2) < 3) {
            throw new RuntimeException("Post 0.96 security features require HFile version >= 3");
        }
        if (!conf.getBoolean("hbase.security.authorization", false)) {
            throw new RuntimeException("Post 2.0.0 security features require set hbase.security.authorization to true");
        }
    }

    public static void verifyAllowed(User user, AccessTestAction ... actions) throws Exception {
        for (AccessTestAction action : actions) {
            try {
                List results;
                Object obj = user.runAs((PrivilegedExceptionAction)action);
                if (obj == null || !(obj instanceof List) || (results = (List)obj) == null || !results.isEmpty()) continue;
                Assert.fail((String)("Empty non null results from action for user '" + user.getShortName() + "'"));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public static void verifyAllowed(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            SecureTestUtil.verifyAllowed(user, action);
        }
    }

    public static void verifyAllowed(User user, AccessTestAction action, int count) throws Exception {
        try {
            Object obj = user.runAs((PrivilegedExceptionAction)action);
            if (obj != null && obj instanceof List) {
                List results = (List)obj;
                if (results != null && results.isEmpty()) {
                    Assert.fail((String)("Empty non null results from action for user '" + user.getShortName() + "'"));
                }
                Assert.assertEquals((long)count, (long)results.size());
            }
        }
        catch (AccessDeniedException ade) {
            Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
        }
    }

    public static void verifyDenied(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            SecureTestUtil.verifyDenied(user, action);
        }
    }

    public static void verifyIfEmptyList(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            try {
                Object obj = user.runAs((PrivilegedExceptionAction)action);
                if (obj != null && obj instanceof List) {
                    List results = (List)obj;
                    if (results == null || results.isEmpty()) continue;
                    Assert.fail((String)("Unexpected action results: " + results + " for user '" + user.getShortName() + "'"));
                    continue;
                }
                Assert.fail((String)("Unexpected results for user '" + user.getShortName() + "'"));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public static void verifyIfNull(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            try {
                Object obj = user.runAs((PrivilegedExceptionAction)action);
                if (obj == null) continue;
                Assert.fail((String)("Non null results from action for user '" + user.getShortName() + "' : " + obj));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public static void verifyDenied(User user, AccessTestAction ... actions) throws Exception {
        for (AccessTestAction action : actions) {
            try {
                user.runAs((PrivilegedExceptionAction)action);
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
            catch (IOException e) {
                boolean isAccessDeniedException = false;
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    for (Throwable ex : ((RetriesExhaustedWithDetailsException)((Object)e)).getCauses()) {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    }
                } else {
                    Throwable ex = e;
                    do {
                        if (ex instanceof RemoteWithExtrasException) {
                            ex = ((RemoteWithExtrasException)ex).unwrapRemoteException();
                        }
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    } while ((ex = ex.getCause()) != null);
                }
                if (isAccessDeniedException) continue;
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
            catch (UndeclaredThrowableException ute) {
                ServiceException se;
                Throwable ex = ute.getUndeclaredThrowable();
                if (ex instanceof PrivilegedActionException) {
                    ex = ((PrivilegedActionException)ex).getException();
                }
                if (ex instanceof ServiceException && (se = (ServiceException)ex).getCause() != null && se.getCause() instanceof AccessDeniedException) {
                    return;
                }
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
        }
    }

    private static List<AccessController> getAccessControllers(MiniHBaseCluster cluster) {
        ArrayList result = Lists.newArrayList();
        for (JVMClusterUtil.RegionServerThread t : cluster.getLiveRegionServerThreads()) {
            for (HRegion region : t.getRegionServer().getOnlineRegionsLocalContext()) {
                Coprocessor cp = region.getCoprocessorHost().findCoprocessor(AccessController.class);
                if (cp == null) continue;
                result.add((AccessController)cp);
            }
        }
        return result;
    }

    private static Map<AccessController, Long> getAuthManagerMTimes(MiniHBaseCluster cluster) {
        HashMap result = Maps.newHashMap();
        for (AccessController ac : SecureTestUtil.getAccessControllers(cluster)) {
            result.put(ac, ac.getAuthManager().getMTime());
        }
        return result;
    }

    private static void updateACLs(final HBaseTestingUtility util, Callable c) throws Exception {
        final Map<AccessController, Long> oldMTimes = SecureTestUtil.getAuthManagerMTimes(util.getHBaseCluster());
        c.call();
        util.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                Map mtimes = SecureTestUtil.getAuthManagerMTimes(util.getHBaseCluster());
                for (Map.Entry e : mtimes.entrySet()) {
                    if (!oldMTimes.containsKey(e.getKey())) {
                        LOG.error("Snapshot of AccessController state does not include instance on region " + ((AccessController)e.getKey()).getRegion().getRegionInfo().getRegionNameAsString());
                        return false;
                    }
                    long old = (Long)oldMTimes.get(e.getKey());
                    long now = (Long)e.getValue();
                    if (now > old) continue;
                    LOG.info("AccessController on region " + ((AccessController)e.getKey()).getRegion().getRegionInfo().getRegionNameAsString() + " has not updated: mtime=" + now);
                    return false;
                }
                return true;
            }
        });
    }

    public static void grantGlobal(final HBaseTestingUtility util, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
                    connection.getAdmin().grant(new UserPermission(user, Permission.newBuilder().withActions(actions).build()), false);
                }
                return null;
            }
        });
    }

    public static void grantGlobal(final User caller, final HBaseTestingUtility util, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration conf = util.getConfiguration();
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf, (User)caller);){
                    connection.getAdmin().grant(new UserPermission(user, Permission.newBuilder().withActions(actions).build()), false);
                }
                return null;
            }
        });
    }

    public static void revokeGlobal(final HBaseTestingUtility util, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
                    connection.getAdmin().revoke(new UserPermission(user, Permission.newBuilder().withActions(actions).build()));
                }
                return null;
            }
        });
    }

    public static void revokeGlobal(final User caller, final HBaseTestingUtility util, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration conf = util.getConfiguration();
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf, (User)caller);){
                    connection.getAdmin().revoke(new UserPermission(user, Permission.newBuilder().withActions(actions).build()));
                }
                return null;
            }
        });
    }

    public static void grantOnNamespace(final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
                    connection.getAdmin().grant(new UserPermission(user, Permission.newBuilder((String)namespace).withActions(actions).build()), false);
                }
                return null;
            }
        });
    }

    public static void grantOnNamespace(final User caller, final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration conf = util.getConfiguration();
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf, (User)caller);){
                    connection.getAdmin().grant(new UserPermission(user, Permission.newBuilder((String)namespace).withActions(actions).build()), false);
                }
                return null;
            }
        });
    }

    public static void grantOnNamespaceUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Connection)connection, (String)namespace, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    LOG.error("grant failed: ", t);
                }
                return null;
            }
        });
    }

    public static void revokeFromNamespaceUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke((Connection)connection, (String)namespace, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    LOG.error("revoke failed: ", t);
                }
                return null;
            }
        });
    }

    public static void revokeFromNamespace(final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
                    connection.getAdmin().revoke(new UserPermission(user, Permission.newBuilder((String)namespace).withActions(actions).build()));
                }
                return null;
            }
        });
    }

    public static void revokeFromNamespace(final User caller, final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration conf = util.getConfiguration();
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf, (User)caller);){
                    connection.getAdmin().revoke(new UserPermission(user, Permission.newBuilder((String)namespace).withActions(actions).build()));
                }
                return null;
            }
        });
    }

    public static void grantOnTable(final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
                    connection.getAdmin().grant(new UserPermission(user, Permission.newBuilder((TableName)table).withFamily(family).withQualifier(qualifier).withActions(actions).build()), false);
                }
                return null;
            }
        });
    }

    public static void grantOnTable(final User caller, final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration conf = util.getConfiguration();
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf, (User)caller);){
                    connection.getAdmin().grant(new UserPermission(user, Permission.newBuilder((TableName)table).withFamily(family).withQualifier(qualifier).withActions(actions).build()), false);
                }
                return null;
            }
        });
    }

    public static void grantOnTableUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Connection)connection, (TableName)table, (String)user, (byte[])family, (byte[])qualifier, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    LOG.error("grant failed: ", t);
                }
                return null;
            }
        });
    }

    public static void grantGlobalUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Connection)connection, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    LOG.error("grant failed: ", t);
                }
                return null;
            }
        });
    }

    public static void revokeFromTable(final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
                    connection.getAdmin().revoke(new UserPermission(user, Permission.newBuilder((TableName)table).withFamily(family).withQualifier(qualifier).withActions(actions).build()));
                }
                return null;
            }
        });
    }

    public static void revokeFromTable(final User caller, final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Configuration conf = util.getConfiguration();
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf, (User)caller);){
                    connection.getAdmin().revoke(new UserPermission(user, Permission.newBuilder((TableName)table).withFamily(family).withQualifier(qualifier).withActions(actions).build()));
                }
                return null;
            }
        });
    }

    public static void revokeFromTableUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke((Connection)connection, (TableName)table, (String)user, (byte[])family, (byte[])qualifier, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    LOG.error("revoke failed: ", t);
                }
                return null;
            }
        });
    }

    public static void revokeGlobalUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke((Connection)connection, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    LOG.error("revoke failed: ", t);
                }
                return null;
            }
        });
    }

    public static Table createTable(HBaseTestingUtility testUtil, TableName tableName, byte[][] families) throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        SecureTestUtil.createTable(testUtil, testUtil.getAdmin(), builder.build());
        return testUtil.getConnection().getTable(tableName);
    }

    public static void createTable(HBaseTestingUtility testUtil, TableDescriptor htd) throws Exception {
        SecureTestUtil.createTable(testUtil, testUtil.getAdmin(), htd);
    }

    public static void createTable(HBaseTestingUtility testUtil, TableDescriptor htd, byte[][] splitKeys) throws Exception {
        SecureTestUtil.createTable(testUtil, testUtil.getAdmin(), htd, splitKeys);
    }

    public static void createTable(HBaseTestingUtility testUtil, Admin admin, TableDescriptor htd) throws Exception {
        SecureTestUtil.createTable(testUtil, admin, htd, null);
    }

    public static void createTable(HBaseTestingUtility testUtil, Admin admin, TableDescriptor htd, byte[][] splitKeys) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class);
        observer.tableCreationLatch = new CountDownLatch(1);
        if (splitKeys != null) {
            admin.createTable(htd, splitKeys);
        } else {
            admin.createTable(htd);
        }
        observer.tableCreationLatch.await();
        observer.tableCreationLatch = null;
        testUtil.waitUntilAllRegionsAssigned(htd.getTableName());
    }

    public static void deleteTable(HBaseTestingUtility testUtil, TableName tableName) throws Exception {
        SecureTestUtil.deleteTable(testUtil, testUtil.getAdmin(), tableName);
    }

    public static void createNamespace(HBaseTestingUtility testUtil, NamespaceDescriptor nsDesc) throws Exception {
        testUtil.getAdmin().createNamespace(nsDesc);
    }

    public static void deleteNamespace(HBaseTestingUtility testUtil, String namespace) throws Exception {
        testUtil.getAdmin().deleteNamespace(namespace);
    }

    public static void deleteTable(HBaseTestingUtility testUtil, Admin admin, TableName tableName) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class);
        observer.tableDeletionLatch = new CountDownLatch(1);
        try {
            admin.disableTable(tableName);
        }
        catch (TableNotEnabledException e) {
            LOG.debug("Table: " + tableName + " already disabled, so just deleting it.");
        }
        admin.deleteTable(tableName);
        observer.tableDeletionLatch.await();
        observer.tableDeletionLatch = null;
    }

    public static String convertToNamespace(String namespace) {
        return '@' + namespace;
    }

    public static void checkGlobalPerms(HBaseTestingUtility testUtil, Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = new Permission(new Permission.Action[]{actions[i]});
        }
        SecureTestUtil.checkPermissions(testUtil.getConfiguration(), perms);
    }

    public static void checkTablePerms(HBaseTestingUtility testUtil, TableName table, byte[] family, byte[] column, Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = Permission.newBuilder((TableName)table).withFamily(family).withQualifier(column).withActions(new Permission.Action[]{actions[i]}).build();
        }
        SecureTestUtil.checkTablePerms(testUtil, perms);
    }

    public static void checkTablePerms(HBaseTestingUtility testUtil, Permission ... perms) throws IOException {
        SecureTestUtil.checkPermissions(testUtil.getConfiguration(), perms);
    }

    private static void checkPermissions(Configuration conf, Permission ... perms) throws IOException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            List hasUserPermissions = conn.getAdmin().hasUserPermissions((List)Lists.newArrayList((Object[])perms));
            for (int i = 0; i < hasUserPermissions.size(); ++i) {
                if (((Boolean)hasUserPermissions.get(i)).booleanValue()) continue;
                throw new AccessDeniedException("Insufficient permissions " + perms[i]);
            }
        }
    }

    public static class MasterSyncObserver
    implements MasterCoprocessor,
    MasterObserver {
        volatile CountDownLatch tableCreationLatch = null;
        volatile CountDownLatch tableDeletionLatch = null;

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            if (this.tableCreationLatch != null) {
                this.tableCreationLatch.countDown();
            }
        }

        public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            if (this.tableDeletionLatch != null) {
                this.tableDeletionLatch.countDown();
            }
        }
    }

    public static interface AccessTestAction
    extends PrivilegedExceptionAction<Object> {
    }
}

